/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup.checks;

import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class InsecureDatabaseCheck {
    private final Set<String> INSECURE_DATABASE_TYPES = ImmutableSet.of((Object)"hsql", (Object)"h2");
    private final SystemInfoUtils systemInfoUtils;

    @Inject
    public InsecureDatabaseCheck(@ComponentImport SystemInfoUtils systemInfoUtils) {
        this.systemInfoUtils = systemInfoUtils;
    }

    public boolean isDatabaseInsecure() {
        String databaseType = this.systemInfoUtils.getDatabaseType().toLowerCase();
        return this.INSECURE_DATABASE_TYPES.contains(databaseType);
    }
}

