/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup.checks;

import com.atlassian.jira.onboarding.postsetup.AnnouncementStatusChecker;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStatus;
import com.atlassian.jira.onboarding.postsetup.checks.EvaluationLicenseAgeCheck;
import com.atlassian.jira.onboarding.postsetup.checks.InsecureDatabaseCheck;
import javax.inject.Inject;
import org.joda.time.Period;
import org.springframework.stereotype.Component;

@Component
public class DatabaseSetUpChecker
implements AnnouncementStatusChecker {
    public static final Period INSECURE_DB_EVALUATION_PERIOD = Period.days((int)21);
    private final EvaluationLicenseAgeCheck licenseAgeCheck;
    private final InsecureDatabaseCheck databaseCheck;

    @Inject
    public DatabaseSetUpChecker(EvaluationLicenseAgeCheck licenseAgeCheck, InsecureDatabaseCheck databaseCheck) {
        this.licenseAgeCheck = licenseAgeCheck;
        this.databaseCheck = databaseCheck;
    }

    @Override
    public PostSetupAnnouncementStatus.Status computeStatus() {
        EvaluationLicenseAgeCheck.LicenseChecker currentLicenseCheck = this.licenseAgeCheck.getCurrentLicenseCheck();
        if (!currentLicenseCheck.isEvaluation()) {
            return PostSetupAnnouncementStatus.Status.FULLFILLED;
        }
        PostSetupAnnouncementStatus.Status status = PostSetupAnnouncementStatus.Status.AWAITS;
        if (currentLicenseCheck.isEvaluationLicenseOld(INSECURE_DB_EVALUATION_PERIOD)) {
            status = this.databaseCheck.isDatabaseInsecure() ? PostSetupAnnouncementStatus.Status.ANNOUNCE : PostSetupAnnouncementStatus.Status.FULLFILLED;
        }
        return status;
    }
}

