/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStatus;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStore;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PostSetupAnnouncementStore.class})
public class AppPropertiesAnnouncementStore
implements PostSetupAnnouncementStore {
    private static final String ALL_PROPERTIES = "com.atlassian.jira.onboarding.postsetup.AppPropertiesPostSetupAnnouncementStore.all";
    private static final Set<String> ALL_STATUSES = Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(PostSetupAnnouncementStatus.Status.values()), (Function)new Function<PostSetupAnnouncementStatus.Status, String>(){

        public String apply(PostSetupAnnouncementStatus.Status input) {
            return input.name();
        }
    }));
    private static final Predicate<Object> IS_VALUE_VALID_STATUS = new Predicate<Object>(){

        public boolean apply(Object value) {
            return ALL_STATUSES.contains(value);
        }
    };
    private static final char PROPERTIES_SEPARATOR = ';';
    private static final String KEY_SEPARATOR = "=";
    final ApplicationProperties applicationProperties;

    @Inject
    public AppPropertiesAnnouncementStore(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    @Nonnull
    public List<PostSetupAnnouncementStatus> getAllStatuses() {
        Map<String, String> activityIdMap = this.extractProperties();
        Map announcementProperties = Maps.filterValues(activityIdMap, IS_VALUE_VALID_STATUS);
        Iterable statuses = Iterables.transform(announcementProperties.entrySet(), (Function)new Function<Map.Entry<String, String>, PostSetupAnnouncementStatus>(){

            public PostSetupAnnouncementStatus apply(Map.Entry<String, String> entry) {
                PostSetupAnnouncementStatus.Status activityStatus = PostSetupAnnouncementStatus.Status.valueOf(entry.getValue());
                return new PostSetupAnnouncementStatus(AppPropertiesAnnouncementStore.this.propertyNameToActivityId(entry.getKey()), activityStatus);
            }
        });
        return Lists.newArrayList((Iterable)statuses);
    }

    @Override
    public void updateStatuses(@Nonnull Iterable<PostSetupAnnouncementStatus> postSetupActivityStatuses) {
        Map<String, String> originalProperties = this.extractProperties();
        HashMap activityIdMap = Maps.newHashMap(originalProperties);
        for (PostSetupAnnouncementStatus status : postSetupActivityStatuses) {
            activityIdMap.put(this.activityIdToPropertyName(status), status.getActivityStatus().name());
        }
        if (!originalProperties.equals(activityIdMap)) {
            this.saveProperties(activityIdMap);
        }
    }

    private String activityIdToPropertyName(PostSetupAnnouncementStatus status) {
        return status.getActivityId();
    }

    private String propertyNameToActivityId(String name) {
        return name;
    }

    @Nonnull
    private Map<String, String> extractProperties() {
        String applicationPropertiesText = this.applicationProperties.getText(ALL_PROPERTIES);
        if (null == applicationPropertiesText) {
            return MapBuilder.emptyMap();
        }
        Splitter propertiesStringSplitter = Splitter.on((char)';').trimResults().omitEmptyStrings();
        MapBuilder propertyMapBuilder = MapBuilder.newBuilder();
        for (String propertyString : propertiesStringSplitter.split((CharSequence)applicationPropertiesText)) {
            String[] keyAndValue = propertyString.split(KEY_SEPARATOR);
            if (keyAndValue.length != 2) continue;
            String key = keyAndValue[0].trim();
            String value = keyAndValue[1].trim();
            if (key.length() <= 0 || value.length() <= 0) continue;
            propertyMapBuilder.add((Object)key, (Object)value);
        }
        return propertyMapBuilder.toMap();
    }

    private void saveProperties(@Nonnull Map<String, String> propertyMap) {
        String propertiesText = Joiner.on((char)';').withKeyValueSeparator(KEY_SEPARATOR).join(propertyMap);
        this.applicationProperties.setText(ALL_PROPERTIES, propertiesText);
    }
}

