/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Outcomes {
    public static final String WORKFLOW_EDITING_LIMITATIONS_ANCHOR_TAG_OPEN = "<a target=\"_blank\" href=\"https://confluence.atlassian.com/display/JIRA/Configuring+Workflow#ConfiguringWorkflow-Limitationswheneditinganactiveworkflow\">";
    public static final String ANCHOR_TAG_CLOSE = "</a>";
    private static I18nHelper i18nHelper;

    @Autowired
    public Outcomes(@ComponentImport I18nHelper i18nHelper) {
        Outcomes.i18nHelper = i18nHelper;
    }

    public static <T> ServiceOutcome<T> okOutcome(T object) {
        return ServiceOutcomeImpl.ok(object);
    }

    public static <T> ServiceOutcome<T> errorOutcome(ErrorCollection errorCollection) {
        return ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
    }

    public static <T> ServiceOutcome<T> errorOutcome(String messageKey, Object ... params) {
        return ServiceOutcomeImpl.error((String)Outcomes.getText(messageKey, params));
    }

    public static <T> ServiceOutcome<T> errorOutcome(ServiceOutcome<?> serviceOutcome) {
        return ServiceOutcomeImpl.error(serviceOutcome);
    }

    public static <T, U> Pair<T, ServiceOutcome<U>> errorPair(String messageKey) {
        return Pair.nicePairOf(null, Outcomes.errorOutcome(messageKey, new Object[0]));
    }

    public static <T, U> Pair<T, ServiceOutcome<U>> errorPair(ServiceOutcome<?> serviceOutcome) {
        return Pair.nicePairOf(null, Outcomes.errorOutcome(serviceOutcome));
    }

    public static <T> ServiceOutcome<T> forbiddenOperationOutcome() {
        return Outcomes.errorOutcome("workflow.designer.forbidden.operation.draft.workflow", WORKFLOW_EDITING_LIMITATIONS_ANCHOR_TAG_OPEN, ANCHOR_TAG_CLOSE);
    }

    public static ErrorCollection errorCollection(String messageKey, Object ... parameters) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(i18nHelper.getText(messageKey, (Object)parameters));
        return errorCollection;
    }

    public static String getText(String messageKey, Object ... arguments) {
        return i18nHelper.getText(messageKey, (Object)arguments);
    }
}

