/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.validators;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.WorkflowGraph;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.WorkflowValidationResult;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.ProblemFactory;
import com.atlassian.jira.plugins.workflowdesigner.validation.spi.GraphValidator;
import com.atlassian.jira.plugins.workflowdesigner.validation.validators.WorkflowGraphAnalyzer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ReachabilityValidator
implements GraphValidator {
    private final ProblemFactory problemFactory;

    @Autowired
    public ReachabilityValidator(ProblemFactory problemFactory) {
        this.problemFactory = problemFactory;
    }

    @Override
    public WorkflowValidationResult validate(WorkflowGraph workflow) {
        if (workflow.getAllNodes().size() <= 2) {
            return WorkflowValidationResult.ok();
        }
        WorkflowGraphAnalyzer analyzer = new WorkflowGraphAnalyzer(workflow);
        WorkflowValidationResult.Builder resultBuilder = WorkflowValidationResult.builder();
        for (Node node : analyzer.unreachableNodes()) {
            resultBuilder.statusProblem(node, this.problemFactory.unreachableState());
        }
        for (Node node : analyzer.deadEndNodes()) {
            resultBuilder.statusProblem(node, this.problemFactory.deadEndState());
        }
        for (Edge edge : analyzer.edgesFromUnreachableStates()) {
            resultBuilder.edgeProblem(edge, this.problemFactory.transitionFromUnreachableState());
        }
        for (Edge edge : analyzer.edgesToDeadEndNodes()) {
            resultBuilder.edgeProblem(edge, this.problemFactory.transitionToDeadEndState());
        }
        return resultBuilder.build();
    }
}

