/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.osgi;

import com.atlassian.osgi.tracker.WaitableServiceTrackerCustomizer;
import com.atlassian.osgi.tracker.WaitableServiceTrackerFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class OsgiSingleServiceClassTracker<T> {
    private final Set<T> services = Collections.synchronizedSet(Sets.newHashSet());
    private final ResettableLazyReference<Set<T>> getter = new ResettableLazyReference<Set<T>>(){

        @Override
        protected Set<T> create() throws Exception {
            return ImmutableSet.copyOf((Collection)OsgiSingleServiceClassTracker.this.services);
        }
    };

    public OsgiSingleServiceClassTracker(Class<T> serviceClass, WaitableServiceTrackerFactory factory) {
        factory.create(serviceClass, new WaitableServiceTrackerCustomizer<T>(){

            @Override
            public T adding(T service) {
                OsgiSingleServiceClassTracker.this.services.add(service);
                OsgiSingleServiceClassTracker.this.getter.reset();
                return service;
            }

            @Override
            public void removed(T service) {
                OsgiSingleServiceClassTracker.this.getter.reset();
                OsgiSingleServiceClassTracker.this.services.remove(service);
            }
        });
    }

    public Set<T> getServices() {
        return this.getter.get();
    }
}

