/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.WorkflowGraph;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class WorkflowGraphImpl
implements WorkflowGraph {
    private final Node root;
    private final Set<Node> allNodes;
    private final Set<Edge> allEdges;
    private final ImmutableSetMultimap<Transition, Edge> allTransitions;

    WorkflowGraphImpl(Node root, Iterable<? extends Node> allNodes, Iterable<Edge> allEdges) {
        this.root = root;
        this.allNodes = ImmutableSet.copyOf(allNodes);
        this.allEdges = ImmutableSet.copyOf(allEdges);
        HashMultimap transitionsToEdges = HashMultimap.create();
        for (Edge edge : allEdges) {
            transitionsToEdges.put((Object)edge.getTransition(), (Object)edge);
        }
        this.allTransitions = ImmutableSetMultimap.copyOf((Multimap)transitionsToEdges);
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public Set<Node> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public Set<Edge> getAllEdges() {
        return this.allEdges;
    }

    @Override
    public Map<Transition, Collection<Edge>> getAllTransitions() {
        return this.allTransitions.asMap();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.root, this.allNodes, this.allEdges, this.allTransitions});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowGraphImpl other = (WorkflowGraphImpl)obj;
        return Objects.equal((Object)this.root, (Object)other.root) && Objects.equal(this.allNodes, other.allNodes) && Objects.equal(this.allEdges, other.allEdges) && Objects.equal(this.allTransitions, other.allTransitions);
    }
}

