/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.PostFunction;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Trigger;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Validator;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.ConditionBuilder;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.PostFunctionImpl;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.TransitionImpl;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.ValidatorImpl;
import com.atlassian.jira.workflow.edit.Workflow;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.List;
import java.util.Map;

final class TransitionBuilder {
    private final Workflow workflow;

    public TransitionBuilder(Workflow workflow) {
        this.workflow = workflow;
    }

    public Transition build(Transition.Type type, ActionDescriptor actionDescriptor) {
        return new SingleTransitionBuilder(actionDescriptor, type).build();
    }

    private static <T> Iterable<T> cast(Iterable<?> iterable, final Class<T> toType) {
        return Options.flatten((Iterable)Iterables.transform(iterable, (Function)new Function<Object, Option<T>>(){

            public Option<T> apply(Object input) {
                if (toType.isInstance(input)) {
                    return Option.some(toType.cast(input));
                }
                return Option.none();
            }
        }));
    }

    private class SingleTransitionBuilder {
        private final ActionDescriptor descriptor;
        private final Transition.Type type;

        public SingleTransitionBuilder(ActionDescriptor descriptor, Transition.Type type) {
            this.descriptor = descriptor;
            this.type = type;
        }

        private Transition build() {
            return new TransitionImpl(this.descriptor.getId(), this.descriptor.getName(), this.type, ConditionBuilder.fromActionDescriptor(this.descriptor), this.buildProperties(), this.buildTriggers(), this.buildPostFunctions(), this.buildValidators());
        }

        private List<Validator> buildValidators() {
            return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)TransitionBuilder.cast(this.descriptor.getValidators(), ValidatorDescriptor.class), (Predicate)new Predicate<ValidatorDescriptor>(){

                public boolean apply(ValidatorDescriptor input) {
                    return "class".equals(input.getType());
                }
            }), (Function)new Function<ValidatorDescriptor, Validator>(){

                public Validator apply(ValidatorDescriptor input) {
                    return new ValidatorImpl((String)input.getArgs().get("class.name"), input.getArgs());
                }
            }));
        }

        private List<PostFunction> buildPostFunctions() {
            return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)TransitionBuilder.this.workflow.getPostFunctionsForTransition(this.descriptor), (Predicate)new Predicate<FunctionDescriptor>(){

                public boolean apply(FunctionDescriptor functionDescriptor) {
                    return "class".equals(functionDescriptor.getType());
                }
            }), (Function)new Function<FunctionDescriptor, PostFunction>(){

                public PostFunction apply(FunctionDescriptor functionDescriptor) {
                    return new PostFunctionImpl((String)functionDescriptor.getArgs().get("class.name"), functionDescriptor.getArgs());
                }
            }));
        }

        private List<Trigger> buildTriggers() {
            return null;
        }

        private Map<String, String> buildProperties() {
            return ImmutableMap.copyOf((Map)this.descriptor.getMetaAttributes());
        }
    }
}

