/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.WorkflowGraph;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.EdgeImpl;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.NodeImpl;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.TransitionBuilder;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.WorkflowGraphImpl;
import com.atlassian.jira.workflow.edit.Workflow;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GraphBuilder {
    private final Workflow workflow;
    private final TransitionBuilder transitionBuilder;
    private final Map<String, NodeImpl> allNodes = Maps.newHashMap();
    private final Set<Edge> allEdges = Sets.newHashSet();

    private GraphBuilder(Workflow workflow) {
        this.workflow = workflow;
        this.transitionBuilder = new TransitionBuilder(workflow);
    }

    public static WorkflowGraph build(Workflow workflow) {
        return new GraphBuilder(workflow).build();
    }

    public WorkflowGraph build() {
        NodeImpl root = this.createRoot();
        this.addNonReachableNodes();
        this.addGlobalTransitions();
        return new WorkflowGraphImpl(root, this.allNodes.values(), this.allEdges);
    }

    private NodeImpl createRoot() {
        NodeImpl root = NodeImpl.rootWithoutEdges();
        this.allNodes.put(root.getName(), root);
        root.setEdges(this.createEdges(root, this.workflow.getInitialActions()));
        return root;
    }

    private void addNonReachableNodes() {
        for (StepDescriptor stepDescriptor : this.workflow.getSteps()) {
            this.createNode(stepDescriptor);
        }
    }

    private void addGlobalTransitions() {
        for (ActionDescriptor globalAction : this.workflow.getGlobalActions()) {
            for (NodeImpl origin : this.allNodes.values()) {
                if (origin.isRoot()) continue;
                Node destination = this.getDestinationNode(origin, globalAction);
                EdgeImpl newEdge = new EdgeImpl(this.transitionBuilder.build(this.isDestinationUndefined(globalAction) ? Transition.Type.ANY_TO_ITSELF : Transition.Type.GLOBAL, globalAction), origin, destination);
                this.allEdges.add(newEdge);
                origin.setEdges((List<Edge>)ImmutableList.builder().addAll(origin.getEdges()).add((Object)newEdge).build());
            }
        }
    }

    private List<Edge> createEdges(final Node source, Collection<ActionDescriptor> actions) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(actions, (Function)new Function<ActionDescriptor, Edge>(){

            public Edge apply(ActionDescriptor descriptor) {
                Node destinationNode = GraphBuilder.this.getDestinationNode(source, descriptor);
                Transition.Type transitionType = source.isRoot() ? Transition.Type.INITIAL : Transition.Type.REGULAR;
                EdgeImpl edge = new EdgeImpl(GraphBuilder.this.transitionBuilder.build(transitionType, descriptor), source, destinationNode);
                GraphBuilder.this.allEdges.add(edge);
                return edge;
            }
        }));
    }

    private Node getDestinationNode(Node origin, ActionDescriptor descriptor) {
        StepDescriptor target = this.workflow.getDescriptor().getStep(descriptor.getUnconditionalResult().getStep());
        if (target == null) {
            return origin;
        }
        this.createNode(target);
        return this.allNodes.get(target.getName());
    }

    private boolean isDestinationUndefined(ActionDescriptor descriptor) {
        return descriptor.getUnconditionalResult().getStep() == -1;
    }

    private void createNode(StepDescriptor target) {
        if (!this.allNodes.containsKey(target.getName())) {
            NodeImpl node = NodeImpl.withoutEdges(target.getId(), target.getName(), target.getMetaAttributes());
            this.allNodes.put(target.getName(), node);
            node.setEdges(this.createEdges(node, target.getActions()));
        }
    }
}

