/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.jira.plugins.workflowdesigner.layout.IdUtils;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;

final class EdgeImpl
implements Edge {
    private final Edge.Id id;
    private final Transition transition;
    private final Node origin;
    private final Node destination;

    public EdgeImpl(Transition transition, Node origin, Node destination) {
        this.id = new EdgeId(transition, origin.getId(), destination.getId());
        this.transition = transition;
        this.origin = origin;
        this.destination = destination;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTransition().getId()});
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Edge && Objects.equal((Object)this.getId(), (Object)((Edge)obj).getId());
    }

    public String toString() {
        return "Edge(" + this.getTransition().getId() + ", " + this.getTransition().getName() + ")";
    }

    @Override
    public Edge.Id getId() {
        return this.id;
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public Node getOrigin() {
        return this.origin;
    }

    @Override
    public Node getDestination() {
        return this.destination;
    }

    @VisibleForTesting
    static final class EdgeId
    implements Edge.Id {
        private final int transitionId;
        private final Transition.Type transitionType;
        private final int originNodeId;
        private final int destinationNodeId;

        public EdgeId(Transition transition, int originNodeId, int destinationNodeId) {
            this.transitionId = transition.getId();
            this.transitionType = transition.getType();
            this.originNodeId = originNodeId;
            this.destinationNodeId = destinationNodeId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.transitionId, this.transitionType, this.originNodeId, this.destinationNodeId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EdgeId other = (EdgeId)obj;
            return Objects.equal((Object)this.transitionId, (Object)other.transitionId) && Objects.equal((Object)((Object)this.transitionType), (Object)((Object)other.transitionType)) && Objects.equal((Object)this.originNodeId, (Object)other.originNodeId) && Objects.equal((Object)this.destinationNodeId, (Object)other.destinationNodeId);
        }

        @Override
        public String toString() {
            return IdUtils.transitionUID(this.transitionId, this.transitionType, this.originNodeId, this.destinationNodeId);
        }
    }
}

