/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Condition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.ConditionLeaf;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.WorkflowEntity;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class Conditions {
    Conditions() {
    }

    public static Condition leaf(String className, Map<String, String> arguments) {
        return new ConditionLeafImpl(className, arguments);
    }

    public static Condition and(Iterable<Condition> conditions) {
        return (Condition)Conditions.tryToSimplify(conditions).getOrElse((Object)new CompositeCondition(Condition.Type.CONJUNCTION, conditions));
    }

    public static Condition or(Iterable<Condition> conditions) {
        return (Condition)Conditions.tryToSimplify(conditions).getOrElse((Object)new CompositeCondition(Condition.Type.ALTERNATIVE, conditions));
    }

    private static Option<Condition> tryToSimplify(Iterable<Condition> conditions) {
        if (Iterables.size(conditions) == 1) {
            return Option.some((Object)Iterables.get(conditions, (int)0));
        }
        return Option.none();
    }

    private static final class ConditionLeafImpl
    extends WorkflowEntity
    implements ConditionLeaf {
        public ConditionLeafImpl(String className, Map<String, String> arguments) {
            super(className, arguments);
        }

        @Override
        public Condition.Type getType() {
            return Condition.Type.LEAF;
        }

        @Override
        public Maybe<List<Condition>> getChildren() {
            return Option.none();
        }

        @Override
        public Maybe<ConditionLeaf> toLeaf() {
            return Option.some((Object)this);
        }

        @Override
        public Iterator<ConditionLeaf> iterator() {
            return Collections.singleton(this).iterator();
        }
    }

    private static final class CompositeCondition
    implements Condition {
        private final Condition.Type type;
        private final List<Condition> children;

        public CompositeCondition(Condition.Type type, Iterable<Condition> children) {
            this.type = type;
            this.children = ImmutableList.copyOf(children);
        }

        @Override
        public Condition.Type getType() {
            return this.type;
        }

        @Override
        public Maybe<List<Condition>> getChildren() {
            return Option.some(this.children);
        }

        @Override
        public Maybe<ConditionLeaf> toLeaf() {
            return Option.none();
        }

        @Override
        public Iterator<ConditionLeaf> iterator() {
            return Iterables.concat((Iterable)Iterables.transform(this.children, (Function)new Function<Condition, Iterable<ConditionLeaf>>(){

                public Iterable<ConditionLeaf> apply(Condition input) {
                    return input;
                }
            })).iterator();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.children});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeCondition other = (CompositeCondition)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal(this.children, other.children);
        }
    }
}

