/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Condition;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.Conditions;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import java.util.Map;
import org.apache.log4j.Logger;

final class ConditionBuilder {
    private static final Logger log = Logger.getLogger(ConditionBuilder.class);
    private final ConditionsDescriptor root;

    private ConditionBuilder(ConditionsDescriptor root) {
        this.root = root;
    }

    public static Option<Condition> fromActionDescriptor(ActionDescriptor actionDescriptor) {
        if (actionDescriptor.getRestriction() == null || actionDescriptor.getRestriction().getConditionsDescriptor() == null) {
            return Option.none();
        }
        return new ConditionBuilder(actionDescriptor.getRestriction().getConditionsDescriptor()).build();
    }

    private Option<Condition> build() {
        return this.fromConditionsDescriptor(this.root);
    }

    private Option<Condition> fromConditionsDescriptor(ConditionsDescriptor descriptor) {
        Iterable conditions = Options.flatten((Iterable)Options.filterNone((Iterable)Iterables.transform((Iterable)descriptor.getConditions(), (Function)new Function<Object, Option<Condition>>(){

            public Option<Condition> apply(Object condition) {
                if (condition instanceof ConditionsDescriptor) {
                    return ConditionBuilder.this.fromConditionsDescriptor((ConditionsDescriptor)condition);
                }
                if (condition instanceof ConditionDescriptor) {
                    return ConditionBuilder.this.fromConditionDescriptor((ConditionDescriptor)condition);
                }
                log.warn((Object)("unrecognized condition descriptor class " + condition.getClass()));
                return Option.none();
            }
        })));
        if (Iterables.isEmpty((Iterable)conditions)) {
            return Option.none();
        }
        return Option.some((Object)("or".equalsIgnoreCase(descriptor.getType()) ? Conditions.or(conditions) : Conditions.and(conditions)));
    }

    private Option<Condition> fromConditionDescriptor(ConditionDescriptor descriptor) {
        if ("class".equals(descriptor.getType())) {
            Map args = descriptor.getArgs();
            return Option.some((Object)Conditions.leaf((String)args.get("class.name"), args));
        }
        log.warn((Object)("unknown condition type: " + descriptor.getType()));
        return Option.none();
    }
}

