/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.api.result;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.Problem;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
@Immutable
public final class WorkflowValidationResult {
    private final Multimap<Integer, Problem> nodeProblems;
    private final Multimap<Edge.Id, Problem> edgeProblems;

    private WorkflowValidationResult(Multimap<Integer, Problem> nodeProblems, Multimap<Edge.Id, Problem> edgeProblems) {
        this.nodeProblems = nodeProblems;
        this.edgeProblems = edgeProblems;
    }

    @JsonProperty
    public Map<Integer, Collection<Problem>> getNodeProblems() {
        return this.nodeProblems.asMap();
    }

    @JsonProperty
    public Map<Edge.Id, Collection<Problem>> getEdgeProblems() {
        return this.edgeProblems.asMap();
    }

    public static WorkflowValidationResult ok() {
        return WorkflowValidationResult.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Multimap<Integer, Problem> statusProblems = ArrayListMultimap.create();
        private final Multimap<Edge.Id, Problem> transitionProblems = ArrayListMultimap.create();

        public Builder statusProblem(Node node, Problem problem) {
            this.statusProblems.put((Object)node.getId(), (Object)problem);
            return this;
        }

        public Builder statusProblems(Node node, Iterable<Problem> problems) {
            this.statusProblems.putAll((Object)node.getId(), problems);
            return this;
        }

        public Builder edgeProblem(Edge edge, Problem problem) {
            this.transitionProblems.put((Object)edge.getId(), (Object)problem);
            return this;
        }

        public Builder edgeProblems(Edge edge, Iterable<Problem> problems) {
            this.transitionProblems.putAll((Object)edge.getId(), problems);
            return this;
        }

        public Builder addValidation(WorkflowValidationResult validationResult) {
            this.transitionProblems.putAll(validationResult.edgeProblems);
            this.statusProblems.putAll(validationResult.nodeProblems);
            return this;
        }

        public WorkflowValidationResult build() {
            return new WorkflowValidationResult((Multimap)ImmutableMultimap.copyOf(this.statusProblems), (Multimap)ImmutableMultimap.copyOf(this.transitionProblems));
        }
    }
}

