/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.utilities;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.workflowdesigner.utilities.WorkflowPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Permissions {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final WorkflowService workflowService;
    private final Workflows workflows;

    @Autowired
    public Permissions(JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, WorkflowService workflowService, @ComponentImport Workflows workflows) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.workflowService = workflowService;
        this.workflows = workflows;
    }

    public boolean userIsAdministrator() {
        return this.userIsAdministrator(this.jiraAuthenticationContext.getLoggedInUser());
    }

    private boolean userIsAdministrator(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    public WorkflowPermissions getWorkflowPermissions(String workflowName, ApplicationUser user) {
        boolean isAdmin = this.userIsAdministrator(user);
        Workflow workflow = this.workflows.getWorkflow(false, workflowName);
        boolean editWorkflowPermission = this.workflowService.isWorkflowEditable(user, (JiraWorkflow)workflow);
        return new WorkflowPermissions.WorkflowPermissionsBuilder().setAdministrator(isAdmin).setEditPropertyOptions(isAdmin).setSelectScreenOnTransition(isAdmin).setCreateStatus(isAdmin).setEditStatus(isAdmin).setDeleteStatus(editWorkflowPermission).setEditWorkflow(editWorkflowPermission).createWorkflowPermissions();
    }
}

