/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.SimpleTransitionData;
import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.WorkflowGlobalTransitions;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/workflows/globalTransitions")
public class WorkflowGlobalTransitionsResource {
    private final Responses responses;
    private final WorkflowGlobalTransitions globalTransitions;

    @Autowired
    public WorkflowGlobalTransitionsResource(Responses responses, @ComponentImport WorkflowGlobalTransitions globalTransitions) {
        this.responses = responses;
        this.globalTransitions = globalTransitions;
    }

    @POST
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response create(@FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId) {
        ServiceOutcome outcome = this.globalTransitions.createGlobalTransition(statusId, workflowName, name, description, screenId);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)outcome.getReturnedValue(), "workflow.edit.adding.global.transition.failed");
    }

    @POST
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    @Path(value="simple")
    public Response addGlobalTransition(@FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId) {
        ServiceOutcome outcome = this.globalTransitions.addGlobalTransitionToWorkflow(workflowName, statusId, name, description, screenId);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        SimpleTransitionData data = new SimpleTransitionData((TransitionData)outcome.getReturnedValue());
        return Responses.createOKResponse(data);
    }

    @DELETE
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response delete(@FormParam(value="transitionId") String transitionId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome outcome = this.globalTransitions.deleteGlobalTransition(transitionId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @PUT
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response update(@FormParam(value="transitionId") int transitionId, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome result = this.globalTransitions.updateGlobalTransition(transitionId, name, description, screenId, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }
}

