/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.plugins.workflowdesigner.rest.Property;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.PropertySet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/userProperties")
public class UserPropertiesResource {
    private static final Logger LOG = Logger.getLogger(UserPropertiesResource.class);
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPropertyManager userPropertyManager;

    @Autowired
    public UserPropertiesResource(I18nHelper i18nHelper, JiraAuthenticationContext jiraAuthenticationContext, UserPropertyManager userPropertyManager) {
        this.i18nHelper = i18nHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPropertyManager = userPropertyManager;
    }

    private Response getNullPropertySetResponse() {
        LOG.error((Object)"UserPropertyManager.getPropertSet() returned null");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProperty(@QueryParam(value="key") String key) {
        if (StringUtils.isEmpty((String)key)) {
            return Responses.createResponse(this.i18nHelper, "workflow.designer.rest.resource.user.properties.no.property", Response.Status.BAD_REQUEST);
        }
        PropertySet propertySet = this.userPropertyManager.getPropertySet(this.jiraAuthenticationContext.getLoggedInUser());
        if (propertySet == null) {
            return this.getNullPropertySetResponse();
        }
        Object value = this.getPropertySafely(key, propertySet);
        return Responses.createOKResponse(new Property(key, value));
    }

    private Object getPropertySafely(String key, PropertySet propertySet) {
        try {
            return propertySet.getAsActualType(key);
        }
        catch (PropertyImplementationException e) {
            return null;
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @RequiresXsrfCheck
    public Response setProperty(Property property) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(this.jiraAuthenticationContext.getLoggedInUser());
        if (propertySet == null) {
            return this.getNullPropertySetResponse();
        }
        String key = property.getKey();
        Object value = property.getValue();
        if (propertySet.exists(key)) {
            propertySet.remove(key);
        }
        propertySet.setAsActualType(key, value);
        return Responses.createOKResponse();
    }
}

