/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.rest.StatusTransformer;
import com.atlassian.jira.plugins.workflowdesigner.utilities.Permissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/statuses")
public class StatusesResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final Permissions permissions;
    private final StatusManager statusManager;
    private final StatusService statusService;

    public StatusesResource(JiraAuthenticationContext jiraAuthenticationContext, Permissions permissions, StatusManager statusManager, StatusService statusService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissions = permissions;
        this.statusManager = statusManager;
        this.statusService = statusService;
    }

    @GET
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response getStatuses() {
        if (!this.permissions.userIsAdministrator()) {
            return Responses.createResponse(this.jiraAuthenticationContext.getI18nHelper(), "workflow.designer.statuses.forbidden", Response.Status.FORBIDDEN);
        }
        return Responses.createOKResponse(Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.statusManager.getStatuses(), (Function)new StatusTransformer())));
    }

    @Path(value="/associatedWorkflowCount")
    @GET
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response getAssociatedWorkflowCount(@QueryParam(value="statusId") String statusId) {
        if (!this.permissions.userIsAdministrator()) {
            return Responses.createResponse(this.jiraAuthenticationContext.getI18nHelper(), "workflow.designer.statuses.forbidden", Response.Status.FORBIDDEN);
        }
        Status status = this.statusService.getStatusById(this.jiraAuthenticationContext.getLoggedInUser(), statusId);
        ServiceOutcome workflowsOutcome = this.statusService.getAssociatedWorkflows(this.jiraAuthenticationContext.getLoggedInUser(), status);
        if (!workflowsOutcome.isValid()) {
            return Responses.createResponse(this.jiraAuthenticationContext.getI18nHelper(), "workflow.designer.retrieving.statuses.error", Response.Status.INTERNAL_SERVER_ERROR);
        }
        int associatedWorkflowsCount = ((List)workflowsOutcome.getReturnedValue()).size();
        return Responses.createOKResponse(associatedWorkflowsCount);
    }
}

