/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Responses {
    private static final Logger log = Logger.getLogger(Responses.class);
    private final Workflows workflows;
    private final WorkflowLayoutManager workflowLayoutManager;
    private final I18nHelper i18nHelper;

    @Autowired
    public Responses(@ComponentImport Workflows workflows, WorkflowLayoutManager workflowLayoutManager, I18nHelper i18nHelper) {
        this.workflows = workflows;
        this.workflowLayoutManager = workflowLayoutManager;
        this.i18nHelper = i18nHelper;
    }

    public static Response createErrorResponse(ServiceOutcome<?> serviceOutcome, Response.Status status) {
        return Responses.createErrorResponse(serviceOutcome.getErrorCollection(), status);
    }

    public static Response createErrorResponse(ErrorCollection errorCollection, Response.Status status) {
        Map.Entry first;
        Preconditions.checkArgument((boolean)errorCollection.hasAnyErrors());
        String errorMessage = (String)Iterables.getFirst((Iterable)errorCollection.getErrorMessages(), null);
        if (errorMessage == null && (first = (Map.Entry)Iterables.getFirst(errorCollection.getErrors().entrySet(), null)) != null) {
            errorMessage = (String)first.getValue();
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).cacheControl(CacheControl.never()).build();
    }

    public static Response createOKResponse() {
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    public Response createEmptyResponse(Response.Status status) {
        return Response.status((Response.Status)status).cacheControl(CacheControl.never()).build();
    }

    public static Response createOKResponse(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    public static Response createResponse(I18nHelper i18nHelper, String messageKey, Response.Status status) {
        String message = i18nHelper.getText(messageKey);
        return Response.status((Response.Status)status).entity((Object)message).cacheControl(CacheControl.never()).build();
    }

    public Response create200Response(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
    }

    public Response createResponse(String messageKey, Response.Status status) {
        String message = this.i18nHelper.getText(messageKey);
        return Response.status((Response.Status)status).entity((Object)message).cacheControl(CacheControl.never()).build();
    }

    public Response getWorkflowLayoutResponse(String workflowName, String errorKey) {
        Workflow workflow = this.workflows.getMutableWorkflowWithoutValidation(workflowName);
        return this.getWorkflowLayoutResponse((JiraWorkflow)workflow, errorKey);
    }

    public Response getWorkflowLayoutResponse(JiraWorkflow workflow, String errorKey) {
        try {
            return Responses.createOKResponse(this.workflowLayoutManager.getLayout(workflow.isDraftWorkflow(), workflow.getName()));
        }
        catch (Exception e) {
            log.error((Object)("getWorkflowLayoutResponse - workflow name:" + workflow.getName()), (Throwable)e);
            return this.createResponse(errorKey, Response.Status.BAD_REQUEST);
        }
    }
}

