/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/workflowMau")
public class MauEventResource {
    private static final Logger LOG = Logger.getLogger(MauEventResource.class);
    private final MauEventService mauEventService;
    private final ProjectService projectService;

    public MauEventResource(MauEventService mauEventService, ProjectService projectService) {
        this.mauEventService = mauEventService;
        this.projectService = projectService;
    }

    @POST
    @RequiresXsrfCheck
    public Response triggerMauEventForProject(@FormParam(value="projectKey") String projectKey) {
        try {
            if (!StringUtils.isEmpty((String)projectKey)) {
                ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(projectKey);
                if (projectResult.isValid()) {
                    this.mauEventService.setApplicationForThreadBasedOnProject(projectResult.getProject());
                }
            } else {
                this.mauEventService.setApplicationForThread(MauApplicationKey.family());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception thrown from MAUEventService.setApplicationForThreadBasedOnProject:" + e.getMessage()), (Throwable)e);
        }
        return Responses.createOKResponse();
    }
}

