/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout.display;

import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.layout.display.TransitionOption;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DisplayTransition {
    private String id;
    private int actionId;
    private String description;
    private boolean globalTransition;
    private boolean loopedTransition;
    private String name;
    private Long screenId;
    private String screenName;
    private Double sourceAngle;
    private String sourceId;
    private Double targetAngle;
    private String targetId;
    private boolean initial;
    private List<TransitionOption> transitionOptions = Collections.emptyList();

    @VisibleForTesting
    public DisplayTransition(String id, String name, String sourceId, String targetId, int actionId, boolean initial, Double sourceAngle, Double targetAngle) {
        this.id = id;
        this.actionId = actionId;
        this.name = name;
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.initial = initial;
        this.sourceAngle = sourceAngle;
        this.targetAngle = targetAngle;
    }

    public DisplayTransition(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="sourceId") String sourceId, @JsonProperty(value="targetId") String targetId, @JsonProperty(value="actionId") int actionId, @JsonProperty(value="initial") boolean initial, @JsonProperty(value="description") String description, @JsonProperty(value="globalTransition") boolean globalTransition, @JsonProperty(value="loopedTransition") boolean loopedTransition, @JsonProperty(value="screenId") Long screenId, @JsonProperty(value="screenName") String screenName, @JsonProperty(value="sourceAngle") Double sourceAngle, @JsonProperty(value="targetAngle") Double targetAngle, @JsonProperty(value="transitionOptions") List<TransitionOption> transitionOptions) {
        this(id, name, sourceId, targetId, actionId, initial, sourceAngle, targetAngle);
        this.description = description;
        this.globalTransition = globalTransition;
        this.loopedTransition = loopedTransition;
        this.screenId = screenId;
        this.screenName = screenName;
        this.transitionOptions = transitionOptions;
    }

    public int getActionId() {
        return this.actionId;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public boolean isGlobalTransition() {
        return this.globalTransition;
    }

    public boolean isLoopedTransition() {
        return this.loopedTransition;
    }

    public String getName() {
        return this.name;
    }

    public Double getSourceAngle() {
        return this.sourceAngle;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Double getTargetAngle() {
        return this.targetAngle;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public Long getScreenId() {
        return this.screenId;
    }

    public String getId() {
        return this.id;
    }

    public List<TransitionOption> getTransitionOptions() {
        return this.transitionOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayTransition that = (DisplayTransition)o;
        if (this.actionId != that.actionId) {
            return false;
        }
        if (this.globalTransition != that.globalTransition) {
            return false;
        }
        if (this.loopedTransition != that.loopedTransition) {
            return false;
        }
        if (this.initial != that.initial) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.screenId != null ? !this.screenId.equals(that.screenId) : that.screenId != null) {
            return false;
        }
        if (this.screenName != null ? !this.screenName.equals(that.screenName) : that.screenName != null) {
            return false;
        }
        if (this.sourceAngle != null ? !this.sourceAngle.equals(that.sourceAngle) : that.sourceAngle != null) {
            return false;
        }
        if (this.sourceId != null ? !this.sourceId.equals(that.sourceId) : that.sourceId != null) {
            return false;
        }
        if (this.targetAngle != null ? !this.targetAngle.equals(that.targetAngle) : that.targetAngle != null) {
            return false;
        }
        if (this.targetId != null ? !this.targetId.equals(that.targetId) : that.targetId != null) {
            return false;
        }
        return !(this.transitionOptions != null ? !this.transitionOptions.equals(that.transitionOptions) : that.transitionOptions != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.actionId;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.globalTransition ? 1 : 0);
        result = 31 * result + (this.loopedTransition ? 1 : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.screenId != null ? this.screenId.hashCode() : 0);
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + (this.sourceAngle != null ? this.sourceAngle.hashCode() : 0);
        result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
        result = 31 * result + (this.targetAngle != null ? this.targetAngle.hashCode() : 0);
        result = 31 * result + (this.targetId != null ? this.targetId.hashCode() : 0);
        result = 31 * result + (this.initial ? 1 : 0);
        result = 31 * result + (this.transitionOptions != null ? this.transitionOptions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DisplayTransition{id='" + this.id + '\'' + ", actionId=" + this.actionId + ", description='" + this.description + '\'' + ", globalTransition=" + this.globalTransition + ", loopedTransition=" + this.loopedTransition + ", name='" + this.name + '\'' + ", screenId=" + this.screenId + ", screenName='" + this.screenName + '\'' + ", sourceAngle=" + this.sourceAngle + ", sourceId='" + this.sourceId + '\'' + ", targetAngle=" + this.targetAngle + ", targetId='" + this.targetId + '\'' + ", initial=" + this.initial + ", transitionOptions=" + this.transitionOptions + '}';
    }

    public static Builder transitionBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private int actionId;
        private String description;
        private boolean global;
        private boolean looped;
        private String name;
        private Long screenId;
        private String screenName;
        private Double sourceAngle;
        private String sourceId;
        private Double targetAngle;
        private String targetId;
        private boolean initial;
        private List<TransitionOption> transitionOptions = Collections.emptyList();

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setData(TransitionData data) {
            this.actionId = data.getActionId();
            this.name = data.getName();
            this.description = data.getDescription();
            this.screenId = data.getScreenId();
            this.screenName = data.getScreenName();
            this.initial = data.isInitial();
            this.global = data.isGlobal();
            this.looped = data.isLooped();
            this.transitionOptions = data.getTransitionOptions();
            return this;
        }

        public Builder setSourceAngle(Double sourceAngle) {
            this.sourceAngle = sourceAngle;
            return this;
        }

        public Builder setSourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder setTargetAngle(Double targetAngle) {
            this.targetAngle = targetAngle;
            return this;
        }

        public Builder setTargetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public DisplayTransition build() {
            return new DisplayTransition(this.id, this.name, this.sourceId, this.targetId, this.actionId, this.initial, this.description, this.global, this.looped, this.screenId, this.screenName, this.sourceAngle, this.targetAngle, this.transitionOptions);
        }
    }
}

