/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout.display;

import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayStatus;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayTransition;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.LoopedTransitionContainer;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.UpdateAuthor;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DisplayLayout {
    private Set<DisplayStatus> statuses = new HashSet<DisplayStatus>();
    private Set<DisplayTransition> transitions = new HashSet<DisplayTransition>();
    private Date updatedDate;
    private UpdateAuthor updateAuthor;
    private LoopedTransitionContainer loopedTransitionContainer;

    public DisplayLayout() {
    }

    public DisplayLayout(@JsonProperty(value="statuses") Set<DisplayStatus> statuses, @JsonProperty(value="transitions") Set<DisplayTransition> transitions, @JsonProperty(value="updatedDate") Date updatedDate, @JsonProperty(value="updateAuthor") UpdateAuthor updateAuthor, @JsonProperty(value="loopedTransitionContainer") LoopedTransitionContainer loopedTransitionContainer) {
        this.statuses = statuses;
        this.transitions = transitions;
        this.updatedDate = updatedDate;
        this.updateAuthor = updateAuthor;
        this.loopedTransitionContainer = loopedTransitionContainer;
    }

    public Set<DisplayStatus> getStatuses() {
        return this.statuses;
    }

    public DisplayLayout addStatus(DisplayStatus status) {
        this.statuses.add(status);
        return this;
    }

    public Set<DisplayTransition> getTransitions() {
        return this.transitions;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public UpdateAuthor getUpdateAuthor() {
        return this.updateAuthor;
    }

    public void setUpdateAuthor(UpdateAuthor updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public DisplayLayout addTransition(DisplayTransition transition) {
        this.transitions.add(transition);
        return this;
    }

    public LoopedTransitionContainer getLoopedTransitionContainer() {
        return this.loopedTransitionContainer;
    }

    public void setLoopedTransitionContainer(LoopedTransitionContainer loopedTransitionContainer) {
        this.loopedTransitionContainer = loopedTransitionContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayLayout layout = (DisplayLayout)o;
        if (!this.statuses.equals(layout.statuses)) {
            return false;
        }
        if (!this.transitions.equals(layout.transitions)) {
            return false;
        }
        if (this.updateAuthor != null ? !this.updateAuthor.equals(layout.updateAuthor) : layout.updateAuthor != null) {
            return false;
        }
        if (this.updatedDate != null ? !this.updatedDate.equals(layout.updatedDate) : layout.updatedDate != null) {
            return false;
        }
        return !(this.loopedTransitionContainer != null ? !this.loopedTransitionContainer.equals(layout.loopedTransitionContainer) : layout.loopedTransitionContainer != null);
    }

    public int hashCode() {
        int result = this.statuses.hashCode();
        result = 31 * result + this.transitions.hashCode();
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        result = 31 * result + (this.updateAuthor != null ? this.updateAuthor.hashCode() : 0);
        result = 31 * result + (this.loopedTransitionContainer != null ? this.loopedTransitionContainer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DisplayLayout{statuses=" + this.statuses + ", transitions=" + this.transitions + ", updatedDate=" + this.updatedDate + ", updateAuthor=" + this.updateAuthor + ", loopedTransitionContainer=" + this.loopedTransitionContainer + '}';
    }
}

