/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializationException;
import com.atlassian.jira.plugins.workflowdesigner.layout.WorkflowLayouts;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayLayout;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.StoredLayout;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.UpdateAuthor;
import com.atlassian.jira.plugins.workflowdesigner.utilities.UserProjectWorkflowUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowLayoutsImpl
implements WorkflowLayouts {
    private static final Logger LOG = Logger.getLogger(WorkflowLayoutsImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowLayoutManager workflowLayoutManager;
    private final Workflows workflows;
    private final UserProjectWorkflowUtilities userProjectWorkflowUtilities;

    @Autowired
    public WorkflowLayoutsImpl(JiraAuthenticationContext jiraAuthenticationContext, UserProjectWorkflowUtilities userProjectWorkflowUtilities, WorkflowLayoutManager workflowLayoutManager, @ComponentImport Workflows workflows) {
        this.workflowLayoutManager = workflowLayoutManager;
        this.workflows = workflows;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userProjectWorkflowUtilities = userProjectWorkflowUtilities;
    }

    @Override
    public ServiceOutcome<Void> saveLayout(String workflowName, boolean isDraft, StoredLayout layout) {
        Workflow workflow = this.workflows.getWorkflow(isDraft, workflowName);
        if (workflow == null) {
            return this.getWorkflowForbiddenOutcome(workflowName);
        }
        if (!this.currentUserCanEditWorkflow(workflow)) {
            return Outcomes.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        layout = new StoredLayout(layout.getStatuses(), layout.getTransitions(), new UpdateAuthor(this.jiraAuthenticationContext.getLoggedInUser()), new Date(), layout.getLoopedTransitionContainer());
        try {
            this.workflowLayoutManager.saveLayout(workflow, layout);
            return Outcomes.okOutcome(null);
        }
        catch (LayoutSerializationException exception) {
            LOG.error((Object)("Error serializing workflow layout for workflow " + workflowName + ", draft = " + isDraft), (Throwable)exception);
            return Outcomes.errorOutcome("workflow.designer.workflow.saving.serialization.failed", new Object[0]);
        }
    }

    private <T> ServiceOutcome<T> getWorkflowForbiddenOutcome(String workflowName) {
        Workflow workflow = this.workflows.getWorkflow(false, workflowName);
        if (workflow != null && !this.currentUserCanEditWorkflow(workflow)) {
            return Outcomes.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        return Outcomes.errorOutcome("workflow.edit.workflow.doesnt.exist", new Object[0]);
    }

    @Override
    public ServiceOutcome<Pair<Boolean, DisplayLayout>> getLayout(String workflowName, boolean getOrCreateDraft, boolean preferDraft) {
        boolean isDraftLayout;
        Workflow workflow;
        if (preferDraft && !getOrCreateDraft) {
            workflow = this.workflows.getDraftWorkflow(workflowName);
            boolean bl = isDraftLayout = workflow != null;
            if (!isDraftLayout) {
                workflow = this.workflows.getWorkflow(false, workflowName);
            }
        } else {
            isDraftLayout = getOrCreateDraft;
            workflow = this.workflows.getWorkflow(getOrCreateDraft, workflowName);
        }
        if (workflow == null) {
            return this.getWorkflowForbiddenOutcome(workflowName);
        }
        if (!this.currentUserCanViewWorkflow(workflowName)) {
            return Outcomes.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        try {
            DisplayLayout layout = this.workflowLayoutManager.getLayout(isDraftLayout, workflowName);
            return Outcomes.okOutcome(Pair.nicePairOf((Object)isDraftLayout, (Object)layout));
        }
        catch (LayoutSerializationException exception) {
            LOG.error((Object)("Error serializing workflow layout for workflow " + workflowName + ", draft = " + isDraftLayout), (Throwable)exception);
            return Outcomes.errorOutcome("workflow.designer.workflow.loading.serialization.failed", new Object[0]);
        }
    }

    private boolean currentUserCanEditWorkflow(Workflow workflow) {
        return workflow != null && workflow.isEditable() && this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), (JiraWorkflow)workflow);
    }

    private boolean currentUserCanViewWorkflow(String workflowName) {
        return this.userProjectWorkflowUtilities.userCanViewWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName);
    }
}

