/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializationException;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializer;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.StoredLayout;
import com.atlassian.jira.plugins.workflowdesigner.utilities.JsonSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LayoutSerializerImpl
implements LayoutSerializer {
    private final JsonSerializer serializer;

    @Autowired
    public LayoutSerializerImpl(JsonSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public String serializeToJson(StoredLayout layout) throws LayoutSerializationException {
        return this.serializer.serialize(layout);
    }

    @Override
    public StoredLayout deserializeFromJson(String json) throws LayoutSerializationException {
        return this.serializer.deserialize(json, StoredLayout.class);
    }
}

