/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;

public final class IdUtils {
    private static final String INITIAL_ID = "I<1>";

    private IdUtils() {
    }

    public static String statusUID(int stepId, boolean initial) {
        return String.format("%s<%d>", initial ? "I" : "S", stepId);
    }

    public static String transitionUID(int actionId, String sourceStatusId, String targetStatusId, boolean initial) {
        return String.format("%s<%d:%s:%s>", initial ? "IA" : "A", actionId, sourceStatusId, targetStatusId);
    }

    public static String transitionUID(int actionId, Transition.Type actionType, int sourceId, int targetId) {
        if (actionType == Transition.Type.INITIAL) {
            return IdUtils.transitionUID(actionId, INITIAL_ID, IdUtils.statusId(targetId), true);
        }
        if (actionType == Transition.Type.GLOBAL) {
            return IdUtils.transitionUID(actionId, IdUtils.statusId(targetId), IdUtils.statusId(targetId), false);
        }
        if (actionType == Transition.Type.ANY_TO_ITSELF) {
            return IdUtils.transitionUID(actionId, IdUtils.statusId(-1), IdUtils.statusId(-1), false);
        }
        return IdUtils.transitionUID(actionId, IdUtils.statusId(sourceId), IdUtils.statusId(targetId), false);
    }

    private static String statusId(int id) {
        return "S<" + id + ">";
    }
}

