/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.data;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissionHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowDesignerAnalyticsDataProvider
implements WebResourceDataProvider {
    private final ProjectPermissionHelper projectPermissionHelper;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public WorkflowDesignerAnalyticsDataProvider(@ComponentImport ProjectPermissionHelper projectPermissionHelper, GlobalPermissionManager globalPermissionManager, @ComponentImport ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper, JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectPermissionHelper = projectPermissionHelper;
        this.globalPermissionManager = globalPermissionManager;
        this.projectWorkflowSchemeHelper = projectWorkflowSchemeHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    WorkflowDesignerAnalyticsDataProvider.this.getJsonData().write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    JSONObject getJsonData() {
        return new JSONObject((Map)ImmutableMap.of((Object)"isolated", (Object)this.getWorkflowName().map(workflowName -> this.projectWorkflowSchemeHelper.isWorkflowIsolated(workflowName)).orElse(false), (Object)"hasExtPermission", (Object)this.getWorkflowName().map(workflowName -> this.projectPermissionHelper.hasExtPermission(this.projectWorkflowSchemeHelper.getAllProjectsForWorkflow(workflowName))).orElse(false), (Object)"isAdmin", (Object)this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.jiraAuthenticationContext.getLoggedInUser())));
    }

    private Optional<String> getWorkflowName() {
        return Optional.ofNullable(ExecutingHttpRequest.get().getParameter("wfName"));
    }
}

