/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.action;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.workflowdesigner.data.WorkflowDesignerAnalyticsDataProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraComponentFactory;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.component.WorkflowHeaderWebComponent;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@WebSudoRequired
public class WorkflowDesignerAction
extends JiraWebActionSupport {
    private final JiraAuthenticationContext authContext;
    private final WorkflowManager workflowManager;
    private final WebResourceAssembler webResourceAssembler;
    private final WorkflowHeaderWebComponent workflowHeaderWebComponent;
    private final WorkflowDesignerAnalyticsDataProvider workflowDesignerAnalyticsDataProvider;
    private String wfName;
    private String workflowMode;
    private JiraWorkflow workflow;
    private Long project;

    @Autowired
    public WorkflowDesignerAction(JiraAuthenticationContext jiraAuthenticationContext, PageBuilderService jiraPageBuilderService, WorkflowManager workflowManager, WorkflowDesignerAnalyticsDataProvider workflowDesignerAnalyticsDataProvider) {
        this.authContext = jiraAuthenticationContext;
        this.webResourceAssembler = jiraPageBuilderService.assembler();
        this.workflowManager = workflowManager;
        this.workflowDesignerAnalyticsDataProvider = workflowDesignerAnalyticsDataProvider;
        this.workflowHeaderWebComponent = (WorkflowHeaderWebComponent)JiraComponentFactory.getInstance().createObject(WorkflowHeaderWebComponent.class);
    }

    public String execute() {
        ApplicationUser user = this.authContext.getLoggedInUser();
        if (user == null) {
            return "notloggedin";
        }
        if (!this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return "nopermission";
        }
        if (StringUtils.isEmpty((String)this.wfName) || StringUtils.isEmpty((String)this.workflowMode) || !this.workflowMode.equals("live") && !this.workflowMode.equals("draft")) {
            return "invalidworkflowname";
        }
        if (this.workflowMode.equals("live") && this.workflowManager.getWorkflow(this.wfName) == null || this.workflowMode.equals("draft") && this.workflowManager.getDraftWorkflow(this.wfName) == null) {
            return "invalidworkflowname";
        }
        this.webResourceAssembler.resources().requireContext("jira.workflow.view");
        this.webResourceAssembler.data().requireData("com.atlassian.jira.plugins.jira-workflow-designer:analytics-data", this.workflowDesignerAnalyticsDataProvider.get());
        return "success";
    }

    public String getWfName() {
        return this.wfName;
    }

    public void setWfName(String wfName) {
        this.wfName = wfName;
    }

    public void setWorkflowMode(String workflowMode) {
        this.workflowMode = workflowMode;
    }

    public JiraWorkflow getWorkflow() {
        if (this.workflow == null) {
            this.workflow = this.workflowMode.equals("live") ? this.workflowManager.getWorkflow(this.wfName) : this.workflowManager.getDraftWorkflow(this.wfName);
        }
        return this.workflow;
    }

    public Long getProject() {
        return this.project;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public String getHeaderHtml() {
        return this.workflowHeaderWebComponent.getHtml(this.getWorkflow(), "workflow_designer", this.getProject());
    }

    public String getLinksHtml() {
        return this.workflowHeaderWebComponent.getLinksHtml(this.getWorkflow(), this.getProject(), "diagram", true);
    }
}

