/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.newsletter;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.util.Clock;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsletterUserPreferencesManager {
    private static final Logger log = LoggerFactory.getLogger(NewsletterUserPreferencesManager.class);
    private static final String NEWSLETTER_SIGNUP_FIRST_VIEW_TIMESTAMP = "newsletter.signup.first.view";
    private static final String OLD_WHATS_NEW_DIALOG_SHOWN_FLAG = "jira.user.whats.new.dont.show.version";
    private static final String NEWSLETTER_SIGNUP_DELAY = "jira.newsletter.tip.delay.days";
    private static final int NEWSLETTER_DEFAULT_DELAY_DAYS = 7;
    private final ApplicationProperties applicationProperties;
    private final UserPreferencesManager userPreferencesManager;
    private final FeatureManager featureManager;
    private final Clock clock;

    public NewsletterUserPreferencesManager(Clock clock, ApplicationProperties applicationProperties, UserPreferencesManager userPreferencesManager, FeatureManager featureManager) {
        this.clock = clock;
        this.applicationProperties = applicationProperties;
        this.userPreferencesManager = userPreferencesManager;
        this.featureManager = featureManager;
    }

    public boolean shouldShowSignupTip(Option<ApplicationUser> user) {
        long signupFirstViewTimestamp;
        if (user.isEmpty()) {
            return false;
        }
        if (this.featureManager.isEnabled("never.display.newsletter.prompts")) {
            return false;
        }
        ExtendedPreferences userPreferences = this.userPreferencesManager.getExtendedPreferences((ApplicationUser)user.get());
        if (this.hasSeenWhatsNewDialog(userPreferences)) {
            return false;
        }
        int delayInDays = this.getConfiguredNewsletterDelay();
        if (delayInDays < 0) {
            return false;
        }
        long currentTime = this.clock.getCurrentDate().getTime();
        return currentTime - (signupFirstViewTimestamp = this.storeFirstViewTimestampIfNeeded(userPreferences, currentTime)) >= TimeUnit.DAYS.toMillis(delayInDays);
    }

    private long storeFirstViewTimestampIfNeeded(ExtendedPreferences userPreferences, long currentTime) {
        if (!userPreferences.containsValue(NEWSLETTER_SIGNUP_FIRST_VIEW_TIMESTAMP)) {
            try {
                userPreferences.setLong(NEWSLETTER_SIGNUP_FIRST_VIEW_TIMESTAMP, currentTime);
            }
            catch (AtlassianCoreException e) {
                log.error("Unknown error storing newsletter signup timestamp user preference.", (Throwable)e);
            }
        }
        return userPreferences.getLong(NEWSLETTER_SIGNUP_FIRST_VIEW_TIMESTAMP);
    }

    private int getConfiguredNewsletterDelay() {
        String newsletterSignupDelayString = this.applicationProperties.getDefaultBackedString(NEWSLETTER_SIGNUP_DELAY);
        return NumberUtils.toInt((String)newsletterSignupDelayString, (int)7);
    }

    private boolean hasSeenWhatsNewDialog(ExtendedPreferences userPreferences) {
        return userPreferences.containsValue(OLD_WHATS_NEW_DIALOG_SHOWN_FLAG);
    }
}

