/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.legacy;

import com.atlassian.jira.plugin.headernav.customcontentlinks.CustomContentLinkServiceFactory;
import com.atlassian.jira.plugin.headernav.legacy.ReadOnlyStudioTabManager;
import com.atlassian.jira.plugin.headernav.legacy.StudioTab;
import com.atlassian.jira.plugin.headernav.navlinks.spi.NavlinksProjectPermissionManager;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLink;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLinkService;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.NoAdminPermissionException;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.project.ProjectManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StudioTabMigrator
implements LifecycleAware {
    static final String MIGRATION_COMPLETE_KEY = "jira-header-plugin.studio-tab-migration-complete";
    private static final Logger log = LoggerFactory.getLogger(StudioTabMigrator.class);
    private final ReadOnlyStudioTabManager studioTabManager;
    private final ProjectManager projectManager;
    private final CustomContentLinkServiceFactory customContentLinkServiceFactory;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final NavlinksProjectPermissionManager navlinksProjectPermissionManager;

    @Autowired
    public StudioTabMigrator(ReadOnlyStudioTabManager studioTabManager, ProjectManager projectManager, CustomContentLinkServiceFactory customContentLinkServiceFactory, PluginSettingsFactory pluginSettingsFactory, NavlinksProjectPermissionManager navlinksProjectPermissionManager) {
        this.studioTabManager = studioTabManager;
        this.projectManager = projectManager;
        this.customContentLinkServiceFactory = customContentLinkServiceFactory;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.navlinksProjectPermissionManager = navlinksProjectPermissionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        if (globalSettings.get(MIGRATION_COMPLETE_KEY) == null) {
            CustomContentLinkService customContentLinkService = this.customContentLinkServiceFactory.getCustomContentLinkService();
            if (customContentLinkService != null) {
                try {
                    this.navlinksProjectPermissionManager.setSysAdmin(true);
                    log.info("Migrating Studio tabs to Content Links");
                    for (String projectKey : this.projectManager.getAllProjectKeys()) {
                        log.info("Migrating Studio tabs for project '" + projectKey + "'");
                        List existingLinks = customContentLinkService.getCustomContentLinks(projectKey);
                        for (StudioTab tab : this.studioTabManager.getAllTabs(projectKey)) {
                            CustomContentLink newLink;
                            if (!tab.getType().equals((Object)StudioTab.StudioTabType.CUSTOM) || !tab.isDisplayed() || existingLinks.contains(newLink = CustomContentLink.builder().key(projectKey).label(tab.getName()).url(tab.getUrl()).build())) continue;
                            try {
                                customContentLinkService.addCustomContentLink(newLink);
                            }
                            catch (NoAdminPermissionException e) {
                                log.error("Permission error migrating Studio Tabs", (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    this.navlinksProjectPermissionManager.setSysAdmin(false);
                }
                globalSettings.put(MIGRATION_COMPLETE_KEY, (Object)"migrated");
            } else {
                log.warn("CustomContentLinkService not supplied by factory, not migrating tabs");
            }
        }
    }

    public void onStop() {
    }
}

