/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.legacy;

@Deprecated
public class StudioTab {
    private StudioTabType type;
    private String name;
    private String url;
    private boolean displayed;
    private String id;

    public StudioTab() {
    }

    public StudioTab(StudioTabType type, String name, String url, boolean displayed) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.displayed = displayed;
    }

    public StudioTab(String id, StudioTabType type, String name, String url, boolean displayed) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.url = url;
        this.displayed = displayed;
    }

    public static StudioTab displayedTabFromType(StudioTabType type) {
        return new StudioTab(type, null, null, true);
    }

    public static StudioTab fromString(String value) {
        String[] split = value.split("\n");
        if (split.length != 4) {
            return null;
        }
        StudioTabType type = StudioTabType.valueOf(split[0]);
        boolean displayed = Boolean.parseBoolean(split[3]);
        return new StudioTab(type, split[1], split[2], displayed);
    }

    public static String toString(StudioTab studioTab) {
        String name = studioTab.getName() != null ? studioTab.getName() : "";
        String url = studioTab.getUrl() != null ? studioTab.getUrl() : "";
        return (Object)((Object)studioTab.getType()) + "\n" + name + "\n" + url + "\n" + studioTab.isDisplayed();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StudioTab)) {
            return false;
        }
        StudioTab studioTab = (StudioTab)o;
        if (this.type != studioTab.type) {
            return false;
        }
        if (this.type == StudioTabType.CUSTOM) {
            if (this.name != null ? !this.name.equals(studioTab.name) : studioTab.name != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(studioTab.url) : studioTab.url != null) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        if (this.type == StudioTabType.CUSTOM) {
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public StudioTabType getType() {
        return this.type;
    }

    public void setType(StudioTabType type) {
        this.type = type;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    static enum StudioTabType {
        ISSUES("studio.tab.issues"),
        WIKI("studio.tab.wiki"),
        SOURCE("studio.tab.source"),
        REVIEWS("studio.tab.reviews"),
        BUILDS("studio.tab.builds"),
        HOME("studio.tab.home"),
        CUSTOM("");

        private final String nameKey;

        private StudioTabType(String nameKey) {
            this.nameKey = nameKey;
        }

        public String getNameKey() {
            return this.nameKey;
        }
    }
}

