/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.customcontentlinks.admin;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;

public class ProjectAdminPermissionChecker {
    private PermissionManager permissionManager;
    private ProjectManager projectManager;
    private UserManager userManager;

    public ProjectAdminPermissionChecker(PermissionManager permissionManager, ProjectManager projectManager, UserManager userManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.userManager = userManager;
    }

    public boolean canAdminister(String projectKey, String userName) {
        ApplicationUser applicationUser;
        Project jiraProject = this.projectManager.getProjectObjByKey(projectKey);
        if (jiraProject != null && (applicationUser = this.userManager.getUserByName(userName)) != null) {
            return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, jiraProject, applicationUser);
        }
        return false;
    }
}

