/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MainHeaderLinksContextProvider
implements ContextProvider {
    static final String SYSTEM_TOP_NAVIGATION_BAR = "system.top.navigation.bar";
    static final String CONSTRUCTED_TOPLEVEL_LINKS_KEY = "headerLinks";
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;

    public MainHeaderLinksContextProvider(@Nonnull SimpleLinkManager simpleLinkManager, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.simpleLinkManager = (SimpleLinkManager)Assertions.notNull((Object)simpleLinkManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.authenticationContext.getUser();
        JiraHelper helper = (JiraHelper)context.get("helper");
        List mainHeaderLinks = this.simpleLinkManager.getLinksForSection(SYSTEM_TOP_NAVIGATION_BAR, user, helper);
        List<HeaderLink> constructedMainHeaderLinks = this.constructHeaderLinks(mainHeaderLinks, user, helper);
        return MapBuilder.newBuilder(context).add((Object)CONSTRUCTED_TOPLEVEL_LINKS_KEY, (Object)Lists.newArrayList(constructedMainHeaderLinks)).toHashMap();
    }

    private List<HeaderLink> constructHeaderLinks(@Nonnull List<SimpleLink> links, @Nullable ApplicationUser user, @Nonnull JiraHelper helper) {
        return links.stream().map(link -> {
            List<HeaderDropdownSection> sections;
            String id = link.getId();
            boolean isLazy = this.simpleLinkManager.shouldLocationBeLazy(id, user, helper);
            if (!isLazy) {
                List simpleSections = this.simpleLinkManager.getSectionsForLocation(id, user, helper);
                sections = simpleSections.stream().map(section -> {
                    String sectionKey = id + "/" + section.getId();
                    List linksForSection = this.simpleLinkManager.getLinksForSection(sectionKey, user, helper);
                    return new HeaderDropdownSection((SimpleLinkSection)section, linksForSection);
                }).collect(Collectors.toList());
            } else {
                sections = Collections.emptyList();
            }
            return new HeaderLink((SimpleLink)link, isLazy, sections);
        }).collect(Collectors.toList());
    }

    public class HeaderDropdownSection {
        private String style;
        private String id;
        private String label;
        private List<SimpleLink> items;

        HeaderDropdownSection(SimpleLinkSection section, List<SimpleLink> links) {
            this.id = section.getId();
            this.label = section.getLabel();
            this.style = section.getStyleClass();
            this.items = links;
        }

        public String getStyle() {
            return this.style;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public List<SimpleLink> getItems() {
            return this.items;
        }
    }

    public class HeaderLink {
        private SimpleLink link;
        private boolean isLazy;
        private List<HeaderDropdownSection> sections;

        HeaderLink(SimpleLink link, boolean isLazy, List<HeaderDropdownSection> sections) {
            this.link = link;
            this.isLazy = isLazy;
            this.sections = sections;
        }

        public String getId() {
            return this.link.getId();
        }

        public String getTitle() {
            return this.link.getTitle();
        }

        public String getLabel() {
            return this.link.getLabel();
        }

        public String getAccessKey() {
            return this.link.getAccessKey();
        }

        public String getUrl() {
            return this.link.getUrl();
        }

        public String getStyleClass() {
            return this.link.getStyleClass();
        }

        public boolean getIsLazy() {
            return this.isLazy;
        }

        public List<HeaderDropdownSection> getSections() {
            return this.sections;
        }
    }
}

