/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.sitemesh.AdminDecoratorSectionLinkItemHelper;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class AdminMenuContextProvider
implements ContextProvider {
    static final String ADMIN_TOP_NAVIGATION_BAR_LOCATION = "system.admin.top";
    static final String CONTEXT_SECTIONS_KEY = "adminHeaderSections";
    static final String CONTEXT_ROOT_ADMIN_MENU_KEY = "rootAdminMenuLink";
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;
    private final AdminDecoratorSectionLinkItemHelper adminDecoratorSectionLinkItemFinder;

    public AdminMenuContextProvider(SimpleLinkManager simpleLinkManager, JiraAuthenticationContext authenticationContext, AdminDecoratorSectionLinkItemHelper adminDecoratorSectionLinkItemFinder) {
        this.simpleLinkManager = (SimpleLinkManager)Assertions.notNull((Object)simpleLinkManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
        this.adminDecoratorSectionLinkItemFinder = adminDecoratorSectionLinkItemFinder;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.authenticationContext.getUser();
        JiraHelper helper = (JiraHelper)context.get("helper");
        Map<SimpleLinkSection, List<SimpleLink>> adminHeaderSections = this.getAdminHeaderSections(user, helper);
        return MapBuilder.newBuilder(context).add((Object)CONTEXT_SECTIONS_KEY, adminHeaderSections).add((Object)CONTEXT_ROOT_ADMIN_MENU_KEY, (Object)AdminMenuContextProvider.getFirstItem(adminHeaderSections)).toMap();
    }

    private static SimpleLink getFirstItem(Map<SimpleLinkSection, List<SimpleLink>> sections) {
        List<SimpleLink> firstSection;
        if (!sections.isEmpty() && !(firstSection = AdminMenuContextProvider.getFirst(sections.values())).isEmpty()) {
            return AdminMenuContextProvider.getFirst(firstSection);
        }
        return null;
    }

    private static <T> T getFirst(Iterable<? extends T> iterable) throws NoSuchElementException {
        return iterable.iterator().next();
    }

    private Map<SimpleLinkSection, List<SimpleLink>> getAdminHeaderSections(ApplicationUser user, JiraHelper helper) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SimpleLinkSection adminHeaderSection : this.simpleLinkManager.getNotEmptySectionsForLocation(ADMIN_TOP_NAVIGATION_BAR_LOCATION, user, helper)) {
            builder.put((Object)adminHeaderSection, this.getAdminHeaderLinks(adminHeaderSection, user, helper));
        }
        return builder.build();
    }

    private List<SimpleLink> getAdminHeaderLinks(SimpleLinkSection section, ApplicationUser user, JiraHelper helper) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SimpleLinkSection subsection : this.simpleLinkManager.getNotEmptySectionsForLocation(section.getId(), user, helper)) {
            Optional<SimpleLink> relevantLink;
            if (subsection.getId().equals("admin_project_current") || !(relevantLink = this.getRelevantLink(subsection, user, helper)).isPresent()) continue;
            builder.add((Object)new SimpleLinkSectionWithLink(subsection, relevantLink.get()));
        }
        return builder.build();
    }

    private Optional<SimpleLink> getRelevantLink(SimpleLinkSection section, ApplicationUser user, JiraHelper helper) {
        return AdminMenuContextProvider.findFirstPresent(Stream.of(() -> this.adminDecoratorSectionLinkItemFinder.findSectionLink(section, user, helper), () -> this.findFirstLinkForSubSection(section, user, helper), () -> this.simpleLinkManager.getLinksForSection(section.getId(), user, helper).stream().findFirst()));
    }

    private static <X> Optional<X> findFirstPresent(Stream<Supplier<Optional<X>>> suppliers) {
        return suppliers.map(Supplier::get).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }

    private Optional<SimpleLink> findFirstLinkForSubSection(SimpleLinkSection section, ApplicationUser user, JiraHelper helper) {
        List nonEmptySubSections = this.simpleLinkManager.getNotEmptySectionsForLocation(section.getId(), user, helper);
        for (SimpleLinkSection subSection : nonEmptySubSections) {
            if ("atl.jira.proj.config".equals(subSection.getId())) continue;
            String subSectionKey = section.getId() + "/" + subSection.getId();
            List links = this.simpleLinkManager.getLinksForSection(subSectionKey, user, helper);
            if (!links.isEmpty()) {
                return Optional.of(links.get(0));
            }
            Optional<SimpleLink> firstLinkOfSubSection = this.findFirstLinkForSubSection(subSection, user, helper);
            if (!firstLinkOfSubSection.isPresent()) continue;
            return firstLinkOfSubSection;
        }
        return Optional.empty();
    }

    private static class SimpleLinkSectionWithLink
    implements SimpleLink {
        private final SimpleLinkSection section;
        private final SimpleLink link;

        private SimpleLinkSectionWithLink(SimpleLinkSection section, SimpleLink link) {
            this.section = section;
            this.link = link;
        }

        public String getUrl() {
            return this.link.getUrl();
        }

        public String getAccessKey() {
            return this.link.getAccessKey();
        }

        public String getLabel() {
            return this.section.getLabel();
        }

        public String getTitle() {
            return this.section.getTitle();
        }

        public String getIconUrl() {
            return this.section.getIconUrl();
        }

        public String getStyleClass() {
            return this.section.getStyleClass();
        }

        public String getId() {
            return this.section.getId();
        }

        public Map<String, String> getParams() {
            return this.section.getParams();
        }

        public Integer getWeight() {
            return this.section.getWeight();
        }
    }
}

