/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.flag.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.flag.FlagDismissalService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/flags/{flagKey}")
public class FlagDismissalResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FlagDismissalService flagDismissalService;

    public FlagDismissalResource(JiraAuthenticationContext jiraAuthenticationContext, FlagDismissalService flagDismissalService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.flagDismissalService = flagDismissalService;
    }

    @PUT
    @Path(value="/dismiss")
    @AnonymousAllowed
    public Response dismiss(@PathParam(value="flagKey") String flagKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        this.flagDismissalService.dismissFlagForUser(flagKey, user);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/reset")
    public Response reset(@PathParam(value="flagKey") String flagKey) {
        this.flagDismissalService.resetFlagDismissals(flagKey);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/removeDismiss")
    public Response removeDismissFlagForUser(@PathParam(value="flagKey") String flagKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        this.flagDismissalService.removeDismissFlagForUser(flagKey, user);
        return Response.noContent().build();
    }
}

