/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.InputStreamApplicationRetriever;
import com.atlassian.security.auth.trustedapps.Null;
import com.atlassian.security.auth.trustedapps.ProxyHostSelector;
import com.atlassian.security.auth.trustedapps.ReaderApplicationRetriever;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLApplicationRetriever
implements ApplicationRetriever {
    private static final Logger log = LoggerFactory.getLogger(URLApplicationRetriever.class);
    private final String baseUrl;
    private final EncryptionProvider encryptionProvider;

    public URLApplicationRetriever(String baseUrl, EncryptionProvider encryptionProvider) {
        Null.not("baseUrl", baseUrl);
        Null.not("encryptionProvider", encryptionProvider);
        this.baseUrl = baseUrl;
        this.encryptionProvider = encryptionProvider;
    }

    @Override
    public Application getApplication() throws ApplicationRetriever.RetrievalException {
        URI uri;
        String certUrl = this.baseUrl + "/admin/appTrustCertificate";
        try {
            uri = new URI(certUrl, false);
        }
        catch (URIException e) {
            throw new ApplicationRetriever.RemoteSystemNotFoundException((Exception)((Object)e));
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new ApplicationRetriever.RemoteSystemNotFoundException(new MalformedURLException("Undefined URI scheme: " + uri));
        }
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return this.getHttpApplication(certUrl);
        }
        return this.getURLApplication(certUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Application getURLApplication(String certUrl) throws ApplicationRetriever.RetrievalException {
        URLConnection con = new URL(certUrl).openConnection();
        con.connect();
        InputStream in = con.getInputStream();
        try {
            InputStreamReader reader = new InputStreamReader(in);
            ReaderApplicationRetriever retriever = new ReaderApplicationRetriever(reader, this.encryptionProvider);
            Application application = retriever.getApplication();
            this.closeQuietly(in);
            return application;
        }
        catch (Throwable throwable) {
            try {
                this.closeQuietly(in);
                throw throwable;
            }
            catch (MalformedURLException e) {
                throw new ApplicationRetriever.RemoteSystemNotFoundException(e);
            }
            catch (IOException e) {
                throw new ApplicationRetriever.RemoteSystemNotFoundException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Application getHttpApplication(String certUrl) throws ApplicationRetriever.RetrievalException {
        int responseCode;
        GetMethod get = new GetMethod(certUrl);
        get.setFollowRedirects(true);
        HttpClient client = new HttpClient();
        this.configureHttpClient(client);
        ProxyHost proxyHost = ProxyHostSelector.withDefaultProxySelector().select(java.net.URI.create(certUrl));
        if (proxyHost != null) {
            log.info("Proxying through {}:{}", (Object)proxyHost.getHostName(), (Object)proxyHost.getPort());
            client.getHostConfiguration().setProxyHost(proxyHost);
        }
        if ((responseCode = client.executeMethod((HttpMethod)get)) >= 300) {
            throw new ApplicationRetriever.ApplicationNotFoundException("Invalid response code of " + responseCode + " returned from: " + certUrl);
        }
        InputStream in = get.getResponseBodyAsStream();
        try {
            Application application = new InputStreamApplicationRetriever(in, this.encryptionProvider).getApplication();
            this.closeQuietly(in);
            return application;
        }
        catch (Throwable throwable) {
            try {
                this.closeQuietly(in);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ApplicationRetriever.ApplicationNotFoundException(e);
            }
            catch (MalformedURLException e) {
                throw new ApplicationRetriever.RemoteSystemNotFoundException(e);
            }
            catch (IOException e) {
                throw new ApplicationRetriever.RemoteSystemNotFoundException(e);
            }
        }
    }

    private void configureHttpClient(HttpClient client) {
        int socketTimeout = Integer.parseInt(System.getProperty("http.socketTimeout", "10000"));
        int connectionTimeout = Integer.parseInt(System.getProperty("http.connectionTimeout", "10000"));
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(connectionTimeout);
        params.setSoTimeout(socketTimeout);
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

