/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.i18n;

import com.atlassian.html.encode.JavascriptEncoder;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.transformer.SearchAndReplaceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.SearchAndReplacer;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.DimensionAwareTransformerUrlBuilder;
import com.atlassian.webresource.api.prebake.DimensionAwareWebResourceTransformerFactory;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.i18n.LocaleUtils;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsI18nTransformer
implements DimensionAwareWebResourceTransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsI18nTransformer.class);
    private static final Pattern PATTERN = Pattern.compile("((?:\\p{Alpha}|[$_])(?:\\p{Alnum}|[$_]){0,1000}(?:\\[['\"]default['\"]])?(?:\\.default)?)\\.I18n\\.getText\\(\\s*(['\"])([\\w.-]+)\\2\\s*([\\),])");
    private static final String QUERY_KEY = "locale";
    private static final String HASH_KEY = "locale-hash";
    private final WebResourceIntegration webResourceIntegration;

    public JsI18nTransformer(WebResourceIntegration webResourceIntegration) {
        this.webResourceIntegration = webResourceIntegration;
    }

    public Dimensions computeDimensions() {
        List locales = StreamSupport.stream(this.webResourceIntegration.getSupportedLocales().spliterator(), false).map(LocaleUtils::serialize).collect(Collectors.toList());
        return Dimensions.empty().andExactly(QUERY_KEY, locales);
    }

    public DimensionAwareTransformerUrlBuilder makeUrlBuilder(TransformerParameters params) {
        return new JsI18nTransformerUrlBuilder();
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters params) {
        return new JsI18nUrlReadingWebResourceTransformer();
    }

    private final class JsI18nUrlReadingWebResourceTransformer
    implements UrlReadingWebResourceTransformer {
        private JsI18nUrlReadingWebResourceTransformer() {
        }

        public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
            final Locale locale = this.getLocaleFromQueryParams(params);
            Function<Matcher, CharSequence> replacer = new Function<Matcher, CharSequence>(){

                public CharSequence apply(Matcher matcher) {
                    return JsI18nUrlReadingWebResourceTransformer.this.doReplace(locale, matcher);
                }
            };
            SearchAndReplacer grep = SearchAndReplacer.create((Pattern)PATTERN, (Function)replacer);
            return new SearchAndReplaceDownloadableResource(transformableResource.nextResource(), grep);
        }

        private Locale getLocaleFromQueryParams(QueryParams params) {
            String localeKey = params.get(JsI18nTransformer.QUERY_KEY);
            if (!StringUtils.isBlank((String)localeKey)) {
                return LocaleUtils.deserialize(localeKey);
            }
            return Locale.US;
        }

        private String doReplace(Locale locale, Matcher matcher) {
            String namespace = matcher.group(1);
            String key = matcher.group(3);
            boolean format = ",".equals(matcher.group(4));
            StringBuilder result = new StringBuilder();
            if (format) {
                result.append(namespace + ".format(");
                String translation = JsI18nTransformer.this.webResourceIntegration.getI18nRawText(locale, key);
                if (null == translation) {
                    translation = key;
                }
                result.append("\"").append(this.jsEncode(translation)).append("\"");
                result.append(",");
            } else {
                String translation = JsI18nTransformer.this.webResourceIntegration.getI18nText(locale, key);
                if (null == translation) {
                    translation = key;
                }
                result.append("\"").append(this.jsEncode(translation)).append("\"");
            }
            return result.toString();
        }

        private String jsEncode(String str) {
            try {
                StringWriter writer = new StringWriter();
                JavascriptEncoder.escape((Writer)writer, (String)str);
                return writer.toString();
            }
            catch (IOException e) {
                logger.error("Error during javascript encoding", (Throwable)e);
                return "";
            }
        }
    }

    private final class JsI18nTransformerUrlBuilder
    implements DimensionAwareTransformerUrlBuilder {
        private JsI18nTransformerUrlBuilder() {
        }

        public void addToUrl(UrlBuilder urlBuilder) {
            String locale = LocaleUtils.serialize(JsI18nTransformer.this.webResourceIntegration.getLocale());
            this.addToUrl(urlBuilder, locale);
        }

        public void addToUrl(UrlBuilder urlBuilder, Coordinate coord) {
            String locale = coord.get(JsI18nTransformer.QUERY_KEY);
            this.addToUrl(urlBuilder, locale);
        }

        private void addToUrl(UrlBuilder urlBuilder, String locale) {
            urlBuilder.addToQueryString(JsI18nTransformer.QUERY_KEY, locale);
            urlBuilder.addToHash(JsI18nTransformer.HASH_KEY, (Object)JsI18nTransformer.this.webResourceIntegration.getI18nStateHash());
        }
    }
}

