/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade.core;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.core.DefaultUpgradeTaskFactoryProcessor;
import com.atlassian.upgrade.core.HostUpgradeTaskCollector;
import com.atlassian.upgrade.core.UpgradeTaskFactoryProcessor;
import com.atlassian.upgrade.core.UpgradeTaskManager;
import com.atlassian.upgrade.core.descriptors.UpgradeTaskFactoryModuleDescriptor;
import com.atlassian.upgrade.spi.LegacyUpgradeTaskFactory;
import com.atlassian.upgrade.spi.UpgradeTaskFactory;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpgradeTaskManager
implements UpgradeTaskManager {
    private final HostUpgradeTaskCollector hostUpgradeTaskCollector;
    private final PluginAccessor pluginAccessor;
    private final UpgradeTaskFactoryProcessor upgradeTaskFactoryProcessor;
    private static final Logger log = LoggerFactory.getLogger(DefaultUpgradeTaskFactoryProcessor.class);

    public DefaultUpgradeTaskManager(HostUpgradeTaskCollector hostUpgradeTaskCollector, PluginAccessor pluginAccessor, UpgradeTaskFactoryProcessor upgradeTaskFactoryProcessor) {
        this.hostUpgradeTaskCollector = hostUpgradeTaskCollector;
        this.pluginAccessor = pluginAccessor;
        this.upgradeTaskFactoryProcessor = upgradeTaskFactoryProcessor;
    }

    @Override
    public boolean upgradeHostApp(UpgradeContext upgradeContext) {
        Optional<UpgradeTaskFactory> upgradeTaskFactoryOptional = this.hostUpgradeTaskCollector.getUpgradeTaskFactory();
        if (upgradeTaskFactoryOptional.isPresent()) {
            UpgradeTaskFactory upgradeTaskFactory = upgradeTaskFactoryOptional.get();
            return this.upgradeTaskFactoryProcessor.performUpgrades("host", upgradeTaskFactory, upgradeContext);
        }
        log.error("Upgrade will not be performed. Can not find upgradeTaskFactory for host app.");
        return false;
    }

    @Override
    public boolean upgradePlugins(UpgradeContext upgradeContext) {
        List<UpgradeTaskFactoryModuleDescriptor> upgradeTaskFactoryModules = this.getUpgradeTaskFactoryModules();
        return upgradeTaskFactoryModules.stream().map(module -> this.upgradeTaskFactoryProcessor.performUpgrades(module.getPluginKey(), module.getModule(), upgradeContext)).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }

    @Override
    public boolean upgradePlugin(UpgradeContext upgradeContext, String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            log.error("Can not perform upgrade for plugin {}. Plugin not accessible.", (Object)pluginKey);
            return false;
        }
        List moduleDescriptors = plugin.getModuleDescriptorsByModuleClass(UpgradeTaskFactory.class);
        return moduleDescriptors.stream().map(module -> this.upgradeTaskFactoryProcessor.performUpgrades(module.getPluginKey(), (UpgradeTaskFactory)module.getModule(), upgradeContext)).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }

    @Override
    public boolean needsUpgrading(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            log.error("Cannot check upgrades for plugin {}. Plugin not accessible.", (Object)pluginKey);
            return false;
        }
        List moduleDescriptors = plugin.getModuleDescriptorsByModuleClass(UpgradeTaskFactory.class);
        return moduleDescriptors.stream().anyMatch(module -> this.upgradeTaskFactoryProcessor.hasPendingUpgrades(module.getPluginKey(), (UpgradeTaskFactory)module.getModule()));
    }

    @Override
    public Optional<String> getProductDisplayName(String factoryKey) {
        return this.getUpgradeTaskFactoryInfo(factoryKey, UpgradeTaskFactory::getProductDisplayName);
    }

    @Override
    public Optional<String> getProductMinimumVersion(String factoryKey) {
        return this.getUpgradeTaskFactoryInfo(factoryKey, UpgradeTaskFactory::getProductMinimumVersion);
    }

    @Override
    public Optional<Integer> getMinimumBuildNumber(String factoryKey) {
        return this.getUpgradeTaskFactoryInfo(factoryKey, UpgradeTaskFactory::getMinimumBuildNumber);
    }

    @Override
    public Optional<Integer> getMinimumSalBuildNumber(String pluginKey) {
        return this.getPluginUpgradeTaskFactoryInfo(pluginKey, LegacyUpgradeTaskFactory::getMinimumSalBuildNumber, LegacyUpgradeTaskFactory.class);
    }

    @Override
    public Optional<Integer> getMinimumAoBuildNumber(String pluginKey) {
        return this.getPluginUpgradeTaskFactoryInfo(pluginKey, LegacyUpgradeTaskFactory::getMinimumAoBuildNumber, LegacyUpgradeTaskFactory.class);
    }

    private <T> Optional<T> getUpgradeTaskFactoryInfo(String factoryKey, Function<UpgradeTaskFactory, T> factoryMethod) {
        boolean isHostApplication = factoryKey.equals("host");
        return isHostApplication ? this.hostUpgradeTaskCollector.getUpgradeTaskFactory().map(factoryMethod) : this.getPluginUpgradeTaskFactoryInfo(factoryKey, factoryMethod, UpgradeTaskFactory.class);
    }

    private <T, F extends UpgradeTaskFactory> Optional<T> getPluginUpgradeTaskFactoryInfo(String pluginKey, Function<F, T> factoryMethod, Class<F> factoryClass) {
        return Optional.ofNullable(this.pluginAccessor.getPlugin(pluginKey)).flatMap(plugin -> this.getEnabledUpgradeTaskModuleDescriptor((Plugin)plugin, factoryClass)).map(ModuleDescriptor::getModule).map(factoryMethod);
    }

    private <F extends UpgradeTaskFactory> Optional<ModuleDescriptor<F>> getEnabledUpgradeTaskModuleDescriptor(Plugin plugin, Class<F> factoryClass) {
        BinaryOperator toOnlyElement = (moduleDescriptor1, moduleDescriptor2) -> {
            throw new RuntimeException("Only one UpgradeTaskFactoryModule should be enabled for a plugin: " + plugin);
        };
        return plugin.getModuleDescriptorsByModuleClass(factoryClass).stream().filter(ModuleDescriptor::isEnabled).reduce(toOnlyElement);
    }

    private List<UpgradeTaskFactoryModuleDescriptor> getUpgradeTaskFactoryModules() {
        return this.pluginAccessor.getActiveModuleDescriptorsByClass(UpgradeTaskFactoryModuleDescriptor.class);
    }
}

