/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.ejb.remote;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.ValidatorRemote;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class RemoteEJBValidator
implements Validator {
    @Override
    public void validate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        ValidatorRemote sessionBean;
        String ejbLocation = (String)args.get("ejb.location");
        Hashtable env = null;
        for (Map.Entry item : args.entrySet()) {
            if (env == null) {
                env = new Hashtable();
            }
            if (!((String)item.getKey()).startsWith("java.naming.")) continue;
            env.put(item.getKey(), item.getValue());
        }
        try {
            EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)new InitialContext().lookup(ejbLocation), EJBHome.class);
            Method create = home.getClass().getMethod("create", new Class[0]);
            sessionBean = (ValidatorRemote)create.invoke((Object)home, new Object[0]);
        }
        catch (Exception e) {
            String message = "Could not get handle to remote EJB validator: " + ejbLocation;
            throw new WorkflowException(message, e);
        }
        try {
            sessionBean.validate(transientVars, args, ps);
        }
        catch (RemoteException e) {
            String message = "Remote exception while executing remote EJB validator: " + ejbLocation;
            throw new WorkflowException(message, e);
        }
    }
}

