/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.ejb.remote;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.ConditionRemote;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class RemoteEJBCondition
implements Condition {
    @Override
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        ConditionRemote sessionBean;
        String ejbLocation = (String)args.get("ejb.location");
        Hashtable env = null;
        for (Map.Entry entry : args.entrySet()) {
            if (env == null) {
                env = new Hashtable();
            }
            if (!((String)entry.getKey()).startsWith("java.naming.")) continue;
            env.put(entry.getKey(), entry.getValue());
        }
        try {
            EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)new InitialContext().lookup(ejbLocation), EJBHome.class);
            Method create = home.getClass().getMethod("create", new Class[0]);
            sessionBean = (ConditionRemote)create.invoke((Object)home, new Object[0]);
        }
        catch (Exception e) {
            String message = "Could not get handle to Remote Condition: " + ejbLocation;
            throw new WorkflowException(message, e);
        }
        try {
            return sessionBean.passesCondition(transientVars, args, ps);
        }
        catch (RemoteException e) {
            String message = "Remote exception encountered while executing Remote Condition: " + ejbLocation;
            throw new WorkflowException(message, e);
        }
    }
}

