/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.ofbiz;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.QueryNotSupportedException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class OfbizWorkflowStore
implements WorkflowStore {
    private static final Log log = LogFactory.getLog(OfbizWorkflowStore.class);
    private GenericDelegator gd;
    private String delegatorName;

    @Override
    public void setEntryState(long entryId, int state) throws StoreException {
        try {
            GenericValue gv = this.gd.findByPrimaryKey("OSWorkflowEntry", UtilMisc.toMap((String)"id", (Object)new Long(entryId)));
            gv.set("state", (Object)new Integer(state));
            this.gd.store(gv);
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not update workflow instance #" + entryId + " to status " + state, e);
        }
    }

    @Override
    public PropertySet getPropertySet(long entryId) {
        HashMap<String, Object> args = new HashMap<String, Object>(2);
        args.put("entityId", new Long(entryId));
        args.put("entityName", "WorkflowEntry");
        return PropertySetManager.getInstance((String)"ofbiz", args);
    }

    @Override
    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        try {
            Long id = this.gd.getNextSeqId("OSCurrentStep");
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("id", id);
            valueMap.put("entryId", new Long(entryId));
            valueMap.put("actionId", new Integer(0));
            valueMap.put("stepId", new Integer(stepId));
            valueMap.put("owner", owner);
            valueMap.put("startDate", new Timestamp(startDate.getTime()));
            Timestamp realDueDate = null;
            if (dueDate != null) {
                realDueDate = new Timestamp(dueDate.getTime());
            }
            valueMap.put("dueDate", realDueDate);
            valueMap.put("finishDate", null);
            valueMap.put("status", status);
            GenericValue gv = this.gd.create("OSCurrentStep", valueMap);
            ArrayList<GenericValue> storeList = new ArrayList<GenericValue>();
            storeList.add(gv);
            if (previousIds != null && (previousIds.length != 1 || previousIds[0] != 0L)) {
                for (int i = 0; i < previousIds.length; ++i) {
                    long previousId = previousIds[i];
                    GenericValue prevGv = this.gd.create("OSCurrentStepPrev", UtilMisc.toMap((String)"id", (Object)id, (String)"previousId", (Object)new Long(previousId)));
                    storeList.add(prevGv);
                }
            }
            this.gd.storeAll(storeList);
            return new SimpleStep(id, entryId, stepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not create new current step for #" + entryId, e);
        }
    }

    @Override
    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        try {
            Long id = this.gd.getNextSeqId("OSWorkflowEntry");
            GenericValue gv = this.gd.create("OSWorkflowEntry", UtilMisc.toMap((String)"id", (Object)id, (String)"name", (Object)workflowName, (String)"state", (Object)new Integer(0)));
            this.gd.storeAll(UtilMisc.toList((Object)gv));
            return new SimpleWorkflowEntry(id, workflowName, 0);
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not create workflow instance", e);
        }
    }

    @Override
    public List findCurrentSteps(long entryId) throws StoreException {
        try {
            List c = this.gd.findByAnd("OSCurrentStep", UtilMisc.toMap((String)"entryId", (Object)new Long(entryId)));
            ArrayList<SimpleStep> list = new ArrayList<SimpleStep>();
            for (GenericValue gv : c) {
                long id = gv.getLong("id");
                int stepId = gv.getInteger("stepId");
                int actionId = gv.getInteger("actionId");
                String owner = gv.getString("owner");
                Timestamp startDate = gv.getTimestamp("startDate");
                Timestamp dueDate = gv.getTimestamp("dueDate");
                Timestamp finishDate = gv.getTimestamp("finishDate");
                String status = gv.getString("status");
                String caller = gv.getString("caller");
                List prevGvs = this.gd.findByAnd("OSCurrentStepPrev", UtilMisc.toMap((String)"id", (Object)new Long(id)));
                long[] prevIds = new long[prevGvs.size()];
                int i = 0;
                for (GenericValue prevGv : prevGvs) {
                    prevIds[i] = prevGv.getLong("previousId");
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, entryId, stepId, actionId, owner, startDate, dueDate, finishDate, status, prevIds, caller);
                list.add(step);
            }
            return list;
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not find current steps for #" + entryId, e);
        }
    }

    @Override
    public WorkflowEntry findEntry(long entryId) throws StoreException {
        try {
            GenericValue gv = this.gd.findByPrimaryKey("OSWorkflowEntry", UtilMisc.toMap((String)"id", (Object)new Long(entryId)));
            String workflowName = gv.getString("name");
            return new SimpleWorkflowEntry(entryId, workflowName, gv.getInteger("state"));
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not find workflow instance #" + entryId, e);
        }
    }

    @Override
    public List findHistorySteps(long entryId) throws StoreException {
        try {
            List c = this.gd.findByAnd("OSHistoryStep", UtilMisc.toMap((String)"entryId", (Object)new Long(entryId)), UtilMisc.toList((Object)"id DESC"));
            ArrayList<SimpleStep> list = new ArrayList<SimpleStep>();
            for (GenericValue gv : c) {
                long id = gv.getLong("id");
                int stepId = gv.getInteger("stepId");
                int actionId = gv.getInteger("actionId");
                String owner = gv.getString("owner");
                Timestamp startDate = gv.getTimestamp("startDate");
                Timestamp dueDate = gv.getTimestamp("dueDate");
                Timestamp finishDate = gv.getTimestamp("finishDate");
                String status = gv.getString("status");
                String caller = gv.getString("caller");
                List prevGvs = this.gd.findByAnd("OSHistoryStepPrev", UtilMisc.toMap((String)"id", (Object)new Long(id)));
                long[] prevIds = new long[prevGvs.size()];
                int i = 0;
                for (GenericValue prevGv : prevGvs) {
                    prevIds[i] = prevGv.getLong("previousId");
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, entryId, stepId, actionId, owner, startDate, dueDate, finishDate, status, prevIds, caller);
                list.add(step);
            }
            return list;
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not find history steps for #" + entryId, e);
        }
    }

    @Override
    public void init(Map props) throws StoreException {
        this.delegatorName = (String)props.get("delegator");
        if (this.delegatorName == null) {
            this.delegatorName = "default";
        }
        try {
            this.gd = GenericDelegator.getGenericDelegator((String)this.delegatorName);
        }
        catch (Exception t) {
            throw new StoreException("Error getting GenericDelegator", t);
        }
    }

    @Override
    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        try {
            GenericValue gv = this.gd.findByPrimaryKey("OSCurrentStep", UtilMisc.toMap((String)"id", (Object)new Long(step.getId())));
            gv.set("actionId", (Object)new Integer(actionId));
            gv.set("finishDate", (Object)new Timestamp(finishDate.getTime()));
            gv.set("status", (Object)status);
            gv.set("caller", (Object)caller);
            this.gd.store(gv);
            SimpleStep theStep = (SimpleStep)step;
            theStep.setStatus(status);
            theStep.setFinishDate(finishDate);
            theStep.setActionId(actionId);
            theStep.setCaller(caller);
            return theStep;
        }
        catch (GenericEntityException e) {
            throw new StoreException("Error marking step #" + step.getId() + " finished", e);
        }
    }

    @Override
    public void moveToHistory(Step step) throws StoreException {
        try {
            Long id = new Long(step.getId());
            this.gd.removeByAnd("OSCurrentStep", UtilMisc.toMap((String)"id", (Object)id));
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("id", id);
            valueMap.put("entryId", new Long(step.getEntryId()));
            valueMap.put("actionId", new Integer(step.getActionId()));
            valueMap.put("stepId", new Integer(step.getStepId()));
            valueMap.put("owner", step.getOwner());
            valueMap.put("startDate", new Timestamp(step.getStartDate().getTime()));
            Timestamp realDueDate = null;
            if (step.getDueDate() != null) {
                realDueDate = new Timestamp(step.getDueDate().getTime());
            }
            valueMap.put("dueDate", realDueDate);
            if (step.getFinishDate() != null) {
                valueMap.put("finishDate", new Timestamp(step.getFinishDate().getTime()));
            }
            valueMap.put("status", step.getStatus());
            valueMap.put("caller", step.getCaller());
            GenericValue gv = this.gd.create("OSHistoryStep", valueMap);
            ArrayList<GenericValue> storeList = new ArrayList<GenericValue>();
            storeList.add(gv);
            long[] previousIds = step.getPreviousStepIds();
            if (previousIds != null) {
                for (int i = 0; i < previousIds.length; ++i) {
                    long previousId = previousIds[i];
                    GenericValue prevGv = this.gd.create("OSHistoryStepPrev", UtilMisc.toMap((String)"id", (Object)id, (String)"previousId", (Object)new Long(previousId)));
                    storeList.add(prevGv);
                }
            }
            this.gd.storeAll(storeList);
        }
        catch (GenericEntityException e) {
            throw new StoreException("Could not move to history step for #" + step.getEntryId(), e);
        }
    }

    @Override
    public List query(WorkflowExpressionQuery query) throws StoreException {
        throw new QueryNotSupportedException("Ofbiz Store does not support queries");
    }

    @Override
    public List query(WorkflowQuery query) throws StoreException {
        throw new QueryNotSupportedException("Ofbiz Store does not support queries");
    }
}

