/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.memory;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.util.DataUtil;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MemoryWorkflowStore
implements WorkflowStore {
    private static HashMap entryCache = new HashMap();
    private static HashMap currentStepsCache = new HashMap();
    private static HashMap historyStepsCache = new HashMap();
    private static HashMap propertySetCache = new HashMap();
    private static long globalEntryId = 1L;
    private static long globalStepId = 1L;

    @Override
    public void setEntryState(long entryId, int state) throws StoreException {
        SimpleWorkflowEntry theEntry = (SimpleWorkflowEntry)this.findEntry(entryId);
        theEntry.setState(state);
    }

    @Override
    public PropertySet getPropertySet(long entryId) {
        PropertySet ps = (PropertySet)propertySetCache.get(new Long(entryId));
        if (ps == null) {
            ps = PropertySetManager.getInstance((String)"memory", null);
            propertySetCache.put(new Long(entryId), ps);
        }
        return ps;
    }

    @Override
    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) {
        long id = globalStepId++;
        SimpleStep step = new SimpleStep(id, entryId, stepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
        ArrayList<SimpleStep> currentSteps = (ArrayList<SimpleStep>)currentStepsCache.get(new Long(entryId));
        if (currentSteps == null) {
            currentSteps = new ArrayList<SimpleStep>();
            currentStepsCache.put(new Long(entryId), currentSteps);
        }
        currentSteps.add(step);
        return step;
    }

    public static void reset() {
        entryCache.clear();
        currentStepsCache.clear();
        historyStepsCache.clear();
        propertySetCache.clear();
    }

    @Override
    public WorkflowEntry createEntry(String workflowName) {
        long id = globalEntryId++;
        SimpleWorkflowEntry entry = new SimpleWorkflowEntry(id, workflowName, 0);
        entryCache.put(new Long(id), entry);
        return entry;
    }

    @Override
    public List findCurrentSteps(long entryId) {
        ArrayList currentSteps = (ArrayList)currentStepsCache.get(new Long(entryId));
        if (currentSteps == null) {
            currentSteps = new ArrayList();
            currentStepsCache.put(new Long(entryId), currentSteps);
        }
        return new ArrayList(currentSteps);
    }

    @Override
    public WorkflowEntry findEntry(long entryId) {
        return (WorkflowEntry)entryCache.get(new Long(entryId));
    }

    @Override
    public List findHistorySteps(long entryId) {
        ArrayList historySteps = (ArrayList)historyStepsCache.get(new Long(entryId));
        if (historySteps == null) {
            historySteps = new ArrayList();
            historyStepsCache.put(new Long(entryId), historySteps);
        }
        return new ArrayList(historySteps);
    }

    @Override
    public void init(Map props) {
    }

    @Override
    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) {
        List currentSteps = (List)currentStepsCache.get(new Long(step.getEntryId()));
        for (SimpleStep theStep : currentSteps) {
            if (theStep.getId() != step.getId()) continue;
            theStep.setStatus(status);
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setCaller(caller);
            return theStep;
        }
        return null;
    }

    @Override
    public void moveToHistory(Step step) {
        List currentSteps = (List)currentStepsCache.get(new Long(step.getEntryId()));
        ArrayList<SimpleStep> historySteps = (ArrayList<SimpleStep>)historyStepsCache.get(new Long(step.getEntryId()));
        if (historySteps == null) {
            historySteps = new ArrayList<SimpleStep>();
            historyStepsCache.put(new Long(step.getEntryId()), historySteps);
        }
        SimpleStep simpleStep = (SimpleStep)step;
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            Step currentStep = (Step)iterator.next();
            if (simpleStep.getId() != currentStep.getId()) continue;
            iterator.remove();
            historySteps.add(0, simpleStep);
            break;
        }
    }

    @Override
    public List query(WorkflowQuery query) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (Map.Entry mapEntry : entryCache.entrySet()) {
            Long entryId = (Long)mapEntry.getKey();
            if (!this.query(entryId, query)) continue;
            results.add(entryId);
        }
        return results;
    }

    @Override
    public List query(WorkflowExpressionQuery query) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (Map.Entry mapEntry : entryCache.entrySet()) {
            Long entryId = (Long)mapEntry.getKey();
            if (!this.query((long)entryId, query)) continue;
            results.add(entryId);
        }
        return results;
    }

    private boolean checkExpression(long entryId, FieldExpression expression) {
        List steps;
        Object value = expression.getValue();
        int operator = expression.getOperator();
        int field = expression.getField();
        int context = expression.getContext();
        Long id = new Long(entryId);
        if (context == 3) {
            SimpleWorkflowEntry theEntry = (SimpleWorkflowEntry)entryCache.get(id);
            if (field == 8) {
                return this.compareText(theEntry.getWorkflowName(), (String)value, operator);
            }
            if (field == 9) {
                return this.compareLong(DataUtil.getInt((Integer)((Integer)value)), theEntry.getState(), operator);
            }
            throw new InvalidParameterException("unknown field");
        }
        if (context == 2) {
            steps = (List)currentStepsCache.get(id);
        } else if (context == 1) {
            steps = (List)historyStepsCache.get(id);
        } else {
            throw new InvalidParameterException("unknown field context");
        }
        if (steps == null) {
            return false;
        }
        boolean expressionResult = false;
        block0 : switch (field) {
            case 4: {
                long actionId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if (!this.compareLong(step.getActionId(), actionId, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 6: {
                String caller = (String)value;
                for (SimpleStep step : steps) {
                    if (!this.compareText(step.getCaller(), caller, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 3: {
                Date finishDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (!this.compareDate(step.getFinishDate(), finishDate, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 1: {
                String owner = (String)value;
                for (SimpleStep step : steps) {
                    if (!this.compareText(step.getOwner(), owner, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 2: {
                Date startDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (!this.compareDate(step.getStartDate(), startDate, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 5: {
                int stepId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if (!this.compareLong(step.getStepId(), stepId, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 7: {
                String status = (String)value;
                for (SimpleStep step : steps) {
                    if (!this.compareText(step.getStatus(), status, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
            case 10: {
                Date dueDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (!this.compareDate(step.getDueDate(), dueDate, operator)) continue;
                    expressionResult = true;
                    break block0;
                }
                break;
            }
        }
        if (expression.isNegate()) {
            return !expressionResult;
        }
        return expressionResult;
    }

    private boolean checkNestedExpression(long entryId, NestedExpression nestedExpression) {
        for (int i = 0; i < nestedExpression.getExpressionCount(); ++i) {
            Expression expression = nestedExpression.getExpression(i);
            boolean expressionResult = expression.isNested() ? this.checkNestedExpression(entryId, (NestedExpression)expression) : this.checkExpression(entryId, (FieldExpression)expression);
            if (nestedExpression.getExpressionOperator() == 6) {
                if (expressionResult) continue;
                return nestedExpression.isNegate();
            }
            if (nestedExpression.getExpressionOperator() != 7 || !expressionResult) continue;
            return !nestedExpression.isNegate();
        }
        if (nestedExpression.getExpressionOperator() == 6) {
            return !nestedExpression.isNegate();
        }
        if (nestedExpression.getExpressionOperator() == 7) {
            return nestedExpression.isNegate();
        }
        throw new InvalidParameterException("unknown operator");
    }

    private boolean compareDate(Date value1, Date value2, int operator) {
        switch (operator) {
            case 1: {
                return value1.compareTo(value2) == 0;
            }
            case 5: {
                return value1.compareTo(value2) != 0;
            }
            case 3: {
                return value1.compareTo(value2) > 0;
            }
            case 2: {
                return value1.compareTo(value2) < 0;
            }
        }
        throw new InvalidParameterException("unknown field operator");
    }

    private boolean compareLong(long value1, long value2, int operator) {
        switch (operator) {
            case 1: {
                return value1 == value2;
            }
            case 5: {
                return value1 != value2;
            }
            case 3: {
                return value1 > value2;
            }
            case 2: {
                return value1 < value2;
            }
        }
        throw new InvalidParameterException("unknown field operator");
    }

    private boolean compareText(String value1, String value2, int operator) {
        switch (operator) {
            case 1: {
                return TextUtils.noNull((String)value1).equals(value2);
            }
            case 5: {
                return !TextUtils.noNull((String)value1).equals(value2);
            }
            case 3: {
                return TextUtils.noNull((String)value1).compareTo(value2) > 0;
            }
            case 2: {
                return TextUtils.noNull((String)value1).compareTo(value2) < 0;
            }
        }
        throw new InvalidParameterException("unknown field operator");
    }

    private boolean query(Long entryId, WorkflowQuery query) {
        if (query.getLeft() == null) {
            return this.queryBasic(entryId, query);
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return this.query(entryId, left) && this.query(entryId, right);
            }
            case 7: {
                return this.query(entryId, left) || this.query(entryId, right);
            }
            case 8: {
                return this.query(entryId, left) ^ this.query(entryId, right);
            }
        }
        return false;
    }

    private boolean query(long entryId, WorkflowExpressionQuery query) {
        Expression expression = query.getExpression();
        if (expression.isNested()) {
            return this.checkNestedExpression(entryId, (NestedExpression)expression);
        }
        return this.checkExpression(entryId, (FieldExpression)expression);
    }

    private boolean queryBasic(Long entryId, WorkflowQuery query) {
        Object value = query.getValue();
        int operator = query.getOperator();
        int field = query.getField();
        int type = query.getType();
        switch (operator) {
            case 1: {
                return this.queryEquals(entryId, field, type, value);
            }
            case 5: {
                return this.queryNotEquals(entryId, field, type, value);
            }
            case 3: {
                return this.queryGreaterThan(entryId, field, type, value);
            }
            case 2: {
                return this.queryLessThan(entryId, field, type, value);
            }
        }
        return false;
    }

    private boolean queryEquals(Long entryId, int field, int type, Object value) {
        List steps = type == 2 ? (List)currentStepsCache.get(entryId) : (List)historyStepsCache.get(entryId);
        if (steps == null) {
            return false;
        }
        switch (field) {
            case 4: {
                long actionId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if ((long)step.getActionId() != actionId) continue;
                    return true;
                }
                return false;
            }
            case 6: {
                String caller = (String)value;
                for (SimpleStep step : steps) {
                    if (!TextUtils.noNull((String)step.getCaller()).equals(caller)) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                Date finishDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (!finishDate.equals(step.getFinishDate())) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                String owner = (String)value;
                for (SimpleStep step : steps) {
                    if (!TextUtils.noNull((String)step.getOwner()).equals(owner)) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                Date startDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (!startDate.equals(step.getStartDate())) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                int stepId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if (stepId != step.getStepId()) continue;
                    return true;
                }
                return false;
            }
            case 7: {
                String status = (String)value;
                for (SimpleStep step : steps) {
                    if (!TextUtils.noNull((String)step.getStatus()).equals(status)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean queryGreaterThan(Long entryId, int field, int type, Object value) {
        List steps = type == 2 ? (List)currentStepsCache.get(entryId) : (List)historyStepsCache.get(entryId);
        switch (field) {
            case 4: {
                long actionId = DataUtil.getLong((Long)((Long)value));
                for (SimpleStep step : steps) {
                    if ((long)step.getActionId() <= actionId) continue;
                    return true;
                }
                return false;
            }
            case 6: {
                String caller = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getCaller()).compareTo(caller) <= 0) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                Date finishDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (step.getFinishDate().compareTo(finishDate) <= 0) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                String owner = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getOwner()).compareTo(owner) <= 0) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                Date startDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (step.getStartDate().compareTo(startDate) <= 0) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                int stepId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if (step.getStepId() <= stepId) continue;
                    return true;
                }
                return false;
            }
            case 7: {
                String status = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getStatus()).compareTo(status) <= 0) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean queryLessThan(Long entryId, int field, int type, Object value) {
        List steps = type == 2 ? (List)currentStepsCache.get(entryId) : (List)historyStepsCache.get(entryId);
        switch (field) {
            case 4: {
                long actionId = DataUtil.getLong((Long)((Long)value));
                for (SimpleStep step : steps) {
                    if ((long)step.getActionId() >= actionId) continue;
                    return true;
                }
                return false;
            }
            case 6: {
                String caller = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getCaller()).compareTo(caller) >= 0) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                Date finishDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (step.getFinishDate().compareTo(finishDate) >= 0) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                String owner = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getOwner()).compareTo(owner) >= 0) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                Date startDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (step.getStartDate().compareTo(startDate) >= 0) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                int stepId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if (step.getStepId() >= stepId) continue;
                    return true;
                }
                return false;
            }
            case 7: {
                String status = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getStatus()).compareTo(status) >= 0) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean queryNotEquals(Long entryId, int field, int type, Object value) {
        List steps = type == 2 ? (List)currentStepsCache.get(entryId) : (List)historyStepsCache.get(entryId);
        switch (field) {
            case 4: {
                long actionId = DataUtil.getLong((Long)((Long)value));
                for (SimpleStep step : steps) {
                    if ((long)step.getActionId() == actionId) continue;
                    return true;
                }
                return false;
            }
            case 6: {
                String caller = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getCaller()).equals(caller)) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                Date finishDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (finishDate.equals(step.getFinishDate())) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                String owner = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getOwner()).equals(owner)) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                Date startDate = (Date)value;
                for (SimpleStep step : steps) {
                    if (startDate.equals(step.getStartDate())) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                int stepId = DataUtil.getInt((Integer)((Integer)value));
                for (SimpleStep step : steps) {
                    if (stepId == step.getStepId()) continue;
                    return true;
                }
                return false;
            }
            case 7: {
                String status = (String)value;
                for (SimpleStep step : steps) {
                    if (TextUtils.noNull((String)step.getStatus()).equals(status)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

