/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.hibernate3;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.hibernate.WorkflowName;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class SpringHibernateWorkflowFactory
extends AbstractWorkflowFactory {
    private static boolean forceReload;
    private Map workflows;
    private SessionFactory sessionFactory;
    private boolean reload = false;
    private boolean validate = false;

    @Override
    public void setLayout(String workflowName, Object layout) {
    }

    @Override
    public Object getLayout(String workflowName) {
        return null;
    }

    @Override
    public boolean isModifiable(String name) {
        return true;
    }

    @Override
    public String getName() {
        return "";
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public WorkflowDescriptor getWorkflow(String name, boolean validate) throws FactoryException {
        if (!this.workflows.containsKey(name)) {
            throw new FactoryException("Unknown workflow name \"" + name + '\"');
        }
        if (this.reload || forceReload) {
            forceReload = false;
            this.loadWorkflow(name, validate);
        }
        return (WorkflowDescriptor)this.workflows.get(name);
    }

    @Override
    public String[] getWorkflowNames() throws FactoryException {
        int i = 0;
        String[] res = new String[this.workflows.keySet().size()];
        Iterator it = this.workflows.keySet().iterator();
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        return res;
    }

    @Override
    public void createWorkflow(String name) {
    }

    public static void forceReload() {
        forceReload = true;
    }

    @Override
    public void initDone() throws FactoryException {
        try {
            this.workflows = new HashMap();
            List workflowNames = new HibernateTemplate(this.sessionFactory).find("select wfn.workflowName from WorkflowName wfn");
            Iterator iter = workflowNames.iterator();
            while (iter.hasNext()) {
                String wfn = iter.next().toString();
                this.loadWorkflow(wfn, this.validate);
            }
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
    }

    @Override
    public boolean removeWorkflow(String name) throws FactoryException {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        WorkflowName wfn = (WorkflowName)hibernateTemplate.load(WorkflowName.class, (Serializable)((Object)name));
        if (wfn != null) {
            hibernateTemplate.delete((Object)wfn);
            return true;
        }
        return false;
    }

    @Override
    public void renameWorkflow(String oldName, String newName) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        WorkflowName wfn = (WorkflowName)hibernateTemplate.load(WorkflowName.class, (Serializable)((Object)oldName));
        wfn.setWorkflowName(newName);
    }

    @Override
    public void save() {
    }

    @Override
    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        WorkflowName wfn = new WorkflowName();
        wfn.setWorkflowName(name);
        wfn.setWorkflowDescriptor(descriptor);
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        hibernateTemplate.saveOrUpdate((Object)wfn);
        this.initDone();
        return false;
    }

    private synchronized void loadWorkflow(final String workflowName, final boolean validate) throws FactoryException {
        try {
            new HibernateTemplate(this.sessionFactory).execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    try {
                        WorkflowName wfn = (WorkflowName)session.load(WorkflowName.class, (Serializable)((Object)workflowName));
                        if (validate) {
                            wfn.getWorkflowDescriptor().validate();
                        }
                        SpringHibernateWorkflowFactory.this.workflows.put(wfn.getWorkflowName(), wfn.getWorkflowDescriptor());
                        return null;
                    }
                    catch (InvalidWorkflowDescriptorException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
    }
}

