/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.hibernate;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.hibernate.DefaultHibernateConfigurationProvider;
import com.opensymphony.workflow.QueryNotSupportedException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep;
import com.opensymphony.workflow.spi.hibernate.HibernateHistoryStep;
import com.opensymphony.workflow.spi.hibernate.HibernateStep;
import com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry;
import com.opensymphony.workflow.util.PropertySetDelegate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class SpringHibernateWorkflowStore
extends HibernateDaoSupport
implements WorkflowStore {
    private PropertySetDelegate propertySetDelegate;
    private String cacheRegion = null;
    private boolean cacheable = false;

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public void setEntryState(long entryId, int state) throws StoreException {
        HibernateWorkflowEntry entry = this.loadEntry(entryId);
        entry.setState(state);
        this.getHibernateTemplate().update((Object)entry);
    }

    @Override
    public PropertySet getPropertySet(long entryId) throws StoreException {
        if (this.propertySetDelegate != null) {
            return this.propertySetDelegate.getPropertySet(entryId);
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("entityName", "OSWorkflowEntry");
        args.put("entityId", new Long(entryId));
        DefaultHibernateConfigurationProvider configurationProvider = new DefaultHibernateConfigurationProvider();
        configurationProvider.setSessionFactory(this.getSessionFactory());
        args.put("configurationProvider", configurationProvider);
        return PropertySetManager.getInstance((String)"hibernate", args);
    }

    public void setPropertySetDelegate(PropertySetDelegate propertySetDelegate) {
        this.propertySetDelegate = propertySetDelegate;
    }

    public PropertySetDelegate getPropertySetDelegate() {
        return this.propertySetDelegate;
    }

    @Override
    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        HibernateCurrentStep step = new HibernateCurrentStep();
        HibernateWorkflowEntry entry = this.loadEntry(entryId);
        step.setEntry(entry);
        step.setStepId(stepId);
        step.setOwner(owner);
        step.setStartDate(startDate);
        step.setDueDate(dueDate);
        step.setStatus(status);
        final ArrayList<Long> stepIdList = new ArrayList<Long>(previousIds.length);
        for (int i = 0; i < previousIds.length; ++i) {
            long previousId = previousIds[i];
            stepIdList.add(new Long(previousId));
        }
        if (!stepIdList.isEmpty()) {
            step.setPreviousSteps((List)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createQuery("FROM " + HibernateCurrentStep.class.getName() + " step WHERE step.id IN (:stepIds)").setParameterList("stepIds", (Collection)stepIdList).setCacheable(SpringHibernateWorkflowStore.this.isCacheable()).setCacheRegion(SpringHibernateWorkflowStore.this.getCacheRegion()).list();
                }
            }));
        } else {
            step.setPreviousSteps(Collections.EMPTY_LIST);
        }
        this.getHibernateTemplate().save((Object)step);
        return step;
    }

    @Override
    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        HibernateWorkflowEntry entry = new HibernateWorkflowEntry();
        entry.setState(0);
        entry.setWorkflowName(workflowName);
        this.getHibernateTemplate().save((Object)entry);
        return entry;
    }

    @Override
    public List findCurrentSteps(final long entryId) throws StoreException {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("FROM " + HibernateCurrentStep.class.getName() + " step WHERE step.entry.id = :entryId").setLong("entryId", entryId).setCacheable(SpringHibernateWorkflowStore.this.isCacheable()).setCacheRegion(SpringHibernateWorkflowStore.this.getCacheRegion()).list();
            }
        });
    }

    @Override
    public WorkflowEntry findEntry(long entryId) throws StoreException {
        return this.loadEntry(entryId);
    }

    @Override
    public List findHistorySteps(final long entryId) throws StoreException {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("FROM " + HibernateHistoryStep.class.getName() + " step WHERE step.entry.id = :entryId").setLong("entryId", entryId).setCacheable(SpringHibernateWorkflowStore.this.isCacheable()).setCacheRegion(SpringHibernateWorkflowStore.this.getCacheRegion()).list();
            }
        });
    }

    @Override
    public void init(Map props) throws StoreException {
    }

    @Override
    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        HibernateCurrentStep currentStep = (HibernateCurrentStep)step;
        currentStep.setActionId(actionId);
        currentStep.setFinishDate(finishDate);
        currentStep.setStatus(status);
        currentStep.setCaller(caller);
        this.getHibernateTemplate().update((Object)currentStep);
        return currentStep;
    }

    @Override
    public void moveToHistory(Step step) throws StoreException {
        HibernateHistoryStep hStep = new HibernateHistoryStep((HibernateStep)step);
        this.getHibernateTemplate().delete((Object)step);
        this.getHibernateTemplate().save((Object)hStep);
    }

    @Override
    public List query(WorkflowQuery query) throws StoreException {
        int qtype = query.getType();
        if (qtype == 0 && query.getLeft() != null) {
            qtype = query.getLeft().getType();
        }
        Class entityClass = qtype == 2 ? HibernateCurrentStep.class : HibernateHistoryStep.class;
        Criteria criteria = this.getSession().createCriteria(entityClass);
        Criterion expression = this.buildExpression(query);
        criteria.add(expression);
        try {
            HashSet<Long> results = new HashSet<Long>();
            for (HibernateStep step : criteria.list()) {
                results.add(new Long(step.getEntryId()));
            }
            return new ArrayList(results);
        }
        catch (HibernateException e) {
            throw new StoreException("Error executing query " + expression, e);
        }
    }

    @Override
    public List query(WorkflowExpressionQuery query) throws StoreException {
        Expression expression = query.getExpression();
        Class entityClass = this.getQueryClass(expression, null);
        Criterion expr = expression.isNested() ? this.buildNested((NestedExpression)expression) : this.queryComparison((FieldExpression)expression);
        Criteria criteria = this.getSession().createCriteria(entityClass);
        criteria.add(expr);
        try {
            HashSet<Long> results = new HashSet<Long>();
            for (Object next : criteria.list()) {
                Long item;
                if (next instanceof HibernateStep) {
                    HibernateStep step = (HibernateStep)next;
                    item = new Long(step.getEntryId());
                } else {
                    WorkflowEntry entry = (WorkflowEntry)next;
                    item = new Long(entry.getId());
                }
                results.add(item);
            }
            return new ArrayList(results);
        }
        catch (HibernateException e) {
            throw new StoreException("Error executing query " + expression, e);
        }
    }

    protected String getCacheRegion() {
        return this.cacheRegion;
    }

    protected boolean isCacheable() {
        return this.cacheable;
    }

    private Criterion getExpression(WorkflowQuery query) {
        int operator = query.getOperator();
        switch (operator) {
            case 1: {
                return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(query.getField()), (Object)query.getValue());
            }
            case 5: {
                return net.sf.hibernate.expression.Expression.not((Criterion)net.sf.hibernate.expression.Expression.like((String)this.getFieldName(query.getField()), (Object)query.getValue()));
            }
            case 3: {
                return net.sf.hibernate.expression.Expression.gt((String)this.getFieldName(query.getField()), (Object)query.getValue());
            }
            case 2: {
                return net.sf.hibernate.expression.Expression.lt((String)this.getFieldName(query.getField()), (Object)query.getValue());
            }
        }
        return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(query.getField()), (Object)query.getValue());
    }

    private String getFieldName(int field) {
        switch (field) {
            case 4: {
                return "actionId";
            }
            case 6: {
                return "caller";
            }
            case 3: {
                return "finishDate";
            }
            case 1: {
                return "owner";
            }
            case 2: {
                return "startDate";
            }
            case 5: {
                return "stepId";
            }
            case 7: {
                return "status";
            }
            case 9: {
                return "state";
            }
            case 8: {
                return "workflowName";
            }
        }
        return "1";
    }

    private Class getQueryClass(Expression expr, Collection classesCache) throws StoreException {
        if (classesCache == null) {
            classesCache = new HashSet<Class>();
        }
        if (expr instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expr;
            switch (fieldExpression.getContext()) {
                case 2: {
                    classesCache.add(HibernateCurrentStep.class);
                    break;
                }
                case 1: {
                    classesCache.add(HibernateHistoryStep.class);
                    break;
                }
                case 3: {
                    classesCache.add(HibernateWorkflowEntry.class);
                    break;
                }
                default: {
                    throw new QueryNotSupportedException("Query for unsupported context " + fieldExpression.getContext());
                }
            }
        } else {
            NestedExpression nestedExpression = (NestedExpression)expr;
            for (int i = 0; i < nestedExpression.getExpressionCount(); ++i) {
                Expression expression = nestedExpression.getExpression(i);
                if (expression.isNested()) {
                    classesCache.add(this.getQueryClass(nestedExpression.getExpression(i), classesCache));
                    continue;
                }
                classesCache.add(this.getQueryClass(expression, classesCache));
            }
        }
        if (classesCache.size() > 1) {
            throw new QueryNotSupportedException("Store does not support nested queries of different types (types found:" + classesCache + ")");
        }
        return (Class)classesCache.iterator().next();
    }

    private Criterion buildExpression(WorkflowQuery query) throws StoreException {
        if (query.getLeft() == null) {
            if (query.getRight() == null) {
                return this.getExpression(query);
            }
            throw new StoreException("Invalid WorkflowQuery object.  QueryLeft is null but QueryRight is not.");
        }
        if (query.getRight() == null) {
            throw new StoreException("Invalid WorkflowQuery object.  QueryLeft is not null but QueryRight is.");
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return net.sf.hibernate.expression.Expression.and((Criterion)this.buildExpression(left), (Criterion)this.buildExpression(right));
            }
            case 7: {
                return net.sf.hibernate.expression.Expression.or((Criterion)this.buildExpression(left), (Criterion)this.buildExpression(right));
            }
            case 8: {
                throw new QueryNotSupportedException("XOR Operator in Queries not supported by " + this.getClass().getName());
            }
        }
        throw new QueryNotSupportedException("Operator '" + operator + "' is not supported by " + this.getClass().getName());
    }

    private Criterion buildNested(NestedExpression nestedExpression) throws StoreException {
        Criterion full = null;
        block4: for (int i = 0; i < nestedExpression.getExpressionCount(); ++i) {
            Criterion expr;
            Expression expression = nestedExpression.getExpression(i);
            if (expression.isNested()) {
                expr = this.buildNested((NestedExpression)nestedExpression.getExpression(i));
            } else {
                FieldExpression sub = (FieldExpression)nestedExpression.getExpression(i);
                expr = this.queryComparison(sub);
                if (sub.isNegate()) {
                    expr = net.sf.hibernate.expression.Expression.not((Criterion)expr);
                }
            }
            if (full == null) {
                full = expr;
                continue;
            }
            switch (nestedExpression.getExpressionOperator()) {
                case 6: {
                    full = net.sf.hibernate.expression.Expression.and((Criterion)full, (Criterion)expr);
                    continue block4;
                }
                case 7: {
                    full = net.sf.hibernate.expression.Expression.or((Criterion)full, (Criterion)expr);
                }
            }
        }
        return full;
    }

    private HibernateWorkflowEntry loadEntry(long entryId) {
        return (HibernateWorkflowEntry)this.getHibernateTemplate().load(HibernateWorkflowEntry.class, (Serializable)new Long(entryId));
    }

    private Criterion queryComparison(FieldExpression expression) {
        int operator = expression.getOperator();
        switch (operator) {
            case 1: {
                return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
            case 5: {
                return net.sf.hibernate.expression.Expression.not((Criterion)net.sf.hibernate.expression.Expression.like((String)this.getFieldName(expression.getField()), (Object)expression.getValue()));
            }
            case 3: {
                return net.sf.hibernate.expression.Expression.gt((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
            case 2: {
                return net.sf.hibernate.expression.Expression.lt((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
        }
        return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
    }
}

