/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.ejb;

import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.ejb.CurrentStepHomeFactory;
import com.opensymphony.workflow.spi.ejb.CurrentStepLocal;
import com.opensymphony.workflow.spi.ejb.CurrentStepPrevHomeFactory;
import com.opensymphony.workflow.spi.ejb.CurrentStepPrevLocal;
import com.opensymphony.workflow.spi.ejb.HistoryStepHomeFactory;
import com.opensymphony.workflow.spi.ejb.HistoryStepLocal;
import com.opensymphony.workflow.spi.ejb.HistoryStepLocalHome;
import com.opensymphony.workflow.spi.ejb.HistoryStepPrevHomeFactory;
import com.opensymphony.workflow.spi.ejb.HistoryStepPrevLocal;
import com.opensymphony.workflow.spi.ejb.StepComparator;
import com.opensymphony.workflow.spi.ejb.WorkflowEntryHomeFactory;
import com.opensymphony.workflow.spi.ejb.WorkflowEntryLocal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.ejb.SessionBean;

public abstract class WorkflowStoreSessionEJB
implements SessionBean {
    public void setEntryState(long entryId, int state) throws StoreException {
        try {
            WorkflowEntryLocal entry = WorkflowEntryHomeFactory.getLocalHome().findByPrimaryKey(new Long(entryId));
            entry.setState(state);
        }
        catch (Exception e) {
            throw new StoreException("Could not find workflow instance #" + entryId, e);
        }
    }

    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        try {
            WorkflowEntryLocal entry = WorkflowEntryHomeFactory.getLocalHome().findByPrimaryKey(new Long(entryId));
            entry.setState(1);
            Timestamp realDueDate = null;
            if (dueDate != null) {
                realDueDate = new Timestamp(dueDate.getTime());
            }
            CurrentStepLocal step = CurrentStepHomeFactory.getLocalHome().create(entryId, stepId, owner, new Timestamp(startDate.getTime()), realDueDate, status);
            long id = step.getId();
            for (int i = 0; i < previousIds.length; ++i) {
                long previousId = previousIds[i];
                CurrentStepPrevHomeFactory.getLocalHome().create(id, previousId);
            }
            return new SimpleStep(id, entryId, stepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
        }
        catch (Exception e) {
            throw new StoreException("Could not create new current step for workflow instance #" + entryId + " step #" + stepId + ":" + e, e);
        }
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        try {
            WorkflowEntryLocal entry = WorkflowEntryHomeFactory.getLocalHome().create(workflowName);
            return new SimpleWorkflowEntry(entry.getId(), entry.getWorkflowName(), 0);
        }
        catch (Exception e) {
            throw new StoreException("Could not create new workflow instance", e);
        }
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        try {
            Collection results = CurrentStepHomeFactory.getLocalHome().findByEntryId(entryId);
            TreeSet<SimpleStep> set = new TreeSet<SimpleStep>(new StepComparator());
            for (CurrentStepLocal stepLocal : results) {
                long id = stepLocal.getId();
                Collection prevSteps = CurrentStepPrevHomeFactory.getLocalHome().findByStepId(id);
                long[] prevIds = new long[prevSteps.size()];
                int i = 0;
                for (CurrentStepPrevLocal stepPrev : prevSteps) {
                    prevIds[i] = stepPrev.getPreviousId();
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, stepLocal.getEntryId(), stepLocal.getStepId(), stepLocal.getActionId(), stepLocal.getOwner(), stepLocal.getStartDate(), stepLocal.getDueDate(), stepLocal.getFinishDate(), stepLocal.getStatus(), prevIds, stepLocal.getCaller());
                set.add(step);
            }
            return new ArrayList(set);
        }
        catch (Exception e) {
            throw new StoreException("Error in findCurrentSteps", e);
        }
    }

    public WorkflowEntry findEntry(long entryId) throws StoreException {
        try {
            WorkflowEntryLocal entry = WorkflowEntryHomeFactory.getLocalHome().findByPrimaryKey(new Long(entryId));
            return new SimpleWorkflowEntry(entry.getId(), entry.getWorkflowName(), entry.getState());
        }
        catch (Exception e) {
            throw new StoreException("Could not find workflow instance #" + entryId, e);
        }
    }

    public List findHistorySteps(long entryId) throws StoreException {
        try {
            Collection results = HistoryStepHomeFactory.getLocalHome().findByEntryId(entryId);
            TreeSet<SimpleStep> set = new TreeSet<SimpleStep>(new StepComparator());
            for (HistoryStepLocal stepRemote : results) {
                long id = stepRemote.getId();
                Collection prevSteps = HistoryStepPrevHomeFactory.getLocalHome().findByStepId(id);
                long[] prevIds = new long[prevSteps.size()];
                int i = 0;
                for (HistoryStepPrevLocal stepPrev : prevSteps) {
                    prevIds[i] = stepPrev.getPreviousId();
                    ++i;
                }
                SimpleStep step = new SimpleStep(stepRemote.getId(), stepRemote.getEntryId(), stepRemote.getStepId(), stepRemote.getActionId(), stepRemote.getOwner(), stepRemote.getStartDate(), stepRemote.getDueDate(), stepRemote.getFinishDate(), stepRemote.getStatus(), prevIds, stepRemote.getCaller());
                set.add(step);
            }
            return new ArrayList(set);
        }
        catch (Exception e) {
            throw new StoreException("Could not find history steps for workflow instance #" + entryId, e);
        }
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        try {
            CurrentStepLocal currentStep = CurrentStepHomeFactory.getLocalHome().findByPrimaryKey(new Long(step.getId()));
            currentStep.setActionId(actionId);
            currentStep.setFinishDate(new Timestamp(finishDate.getTime()));
            currentStep.setStatus(status);
            currentStep.setCaller(caller);
            SimpleStep theStep = (SimpleStep)step;
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setStatus(status);
            theStep.setCaller(caller);
            return theStep;
        }
        catch (Exception e) {
            throw new StoreException("Could not mark step finished for #" + step.getEntryId(), e);
        }
    }

    public void moveToHistory(Step step) throws StoreException {
        Long id = new Long(step.getId());
        try {
            CurrentStepLocal currentStep = CurrentStepHomeFactory.getLocalHome().findByPrimaryKey(id);
            long[] previousIds = step.getPreviousStepIds();
            Timestamp realDueDate = null;
            if (step.getDueDate() != null) {
                realDueDate = new Timestamp(step.getDueDate().getTime());
            }
            Timestamp finishedDate = null;
            if (step.getFinishDate() != null) {
                finishedDate = new Timestamp(step.getFinishDate().getTime());
            }
            HistoryStepLocalHome historyHome = HistoryStepHomeFactory.getLocalHome();
            historyHome.create(id, step.getEntryId(), step.getStepId(), step.getActionId(), step.getOwner(), new Timestamp(step.getStartDate().getTime()), realDueDate, finishedDate, step.getStatus(), step.getCaller());
            for (int i = 0; i < previousIds.length; ++i) {
                long previousId = previousIds[i];
                HistoryStepPrevHomeFactory.getLocalHome().create(id, previousId);
            }
            Collection oldPrevSteps = CurrentStepPrevHomeFactory.getLocalHome().findByStepId(id);
            for (CurrentStepPrevLocal oldPrevStep : oldPrevSteps) {
                oldPrevStep.remove();
            }
            currentStep.remove();
        }
        catch (Exception e) {
            throw new StoreException("Could not move step to history for workflow instance #" + id, e);
        }
    }

    public List query(WorkflowQuery query) throws StoreException {
        throw new StoreException("EJB store does not support queries");
    }

    public List query(WorkflowExpressionQuery query) throws StoreException {
        throw new StoreException("EJB store does not support queries");
    }
}

