/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.PermissionDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StepDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List actions = new ArrayList();
    protected List commonActions = new ArrayList();
    protected List permissions = new ArrayList();
    protected List postFunctions = new ArrayList();
    protected List preFunctions = new ArrayList();
    protected Map metaAttributes = new HashMap();
    protected String name;
    protected boolean hasActions = false;

    StepDescriptor() {
    }

    StepDescriptor(Element step) {
        this.init(step);
    }

    StepDescriptor(Element step, AbstractDescriptor parent) {
        this.setParent(parent);
        this.init(step);
    }

    public ActionDescriptor getAction(int id) {
        for (ActionDescriptor action : this.actions) {
            if (action.getId() != id) continue;
            return action;
        }
        return null;
    }

    public List getActions() {
        return this.actions;
    }

    public List getCommonActions() {
        return this.commonActions;
    }

    public void setMetaAttributes(Map metaAttributes) {
        this.metaAttributes = metaAttributes;
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List getPermissions() {
        return this.permissions;
    }

    public void setPostFunctions(List postFunctions) {
        this.postFunctions = postFunctions;
    }

    public List getPostFunctions() {
        return this.postFunctions;
    }

    public void setPreFunctions(List preFunctions) {
        this.preFunctions = preFunctions;
    }

    public List getPreFunctions() {
        return this.preFunctions;
    }

    public void removeActions() {
        this.commonActions.clear();
        this.actions.clear();
        this.hasActions = false;
    }

    public boolean resultsInJoin(int join) {
        for (ActionDescriptor actionDescriptor : this.actions) {
            if (actionDescriptor.getUnconditionalResult().getJoin() == join) {
                return true;
            }
            List results = actionDescriptor.getConditionalResults();
            for (ConditionalResultDescriptor resultDescriptor : results) {
                if (resultDescriptor.getJoin() != join) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void validate() throws InvalidWorkflowDescriptorException {
        if (this.commonActions.size() == 0 && this.actions.size() == 0 && this.hasActions) {
            throw new InvalidWorkflowDescriptorException("Step '" + this.name + "' actions element must contain at least one action or common-action");
        }
        if (this.getId() == -1) {
            throw new InvalidWorkflowDescriptorException("Cannot use a step ID of -1 as it is a reserved value");
        }
        ValidationHelper.validate(this.actions);
        ValidationHelper.validate(this.permissions);
        ValidationHelper.validate(this.preFunctions);
        ValidationHelper.validate(this.postFunctions);
        for (Object o : this.commonActions) {
            try {
                Integer actionId = new Integer(o.toString());
                ActionDescriptor commonActionReference = (ActionDescriptor)((WorkflowDescriptor)this.getParent()).getCommonActions().get(actionId);
                if (commonActionReference != null) continue;
                throw new InvalidWorkflowDescriptorException("Common action " + actionId + " specified in step " + this.getName() + " does not exist");
            }
            catch (NumberFormatException ex) {
                throw new InvalidWorkflowDescriptorException("Common action " + o + " is not a valid action ID");
            }
        }
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        FunctionDescriptor function;
        XMLUtil.printIndent(out, indent++);
        out.print("<step id=\"" + this.getId() + "\"");
        if (this.name != null && this.name.length() > 0) {
            out.print(" name=\"" + XMLUtil.encode(this.name) + "\"");
        }
        out.println(">");
        for (Map.Entry entry : this.metaAttributes.entrySet()) {
            XMLUtil.printIndent(out, indent);
            out.print("<meta name=\"");
            out.print(entry.getKey());
            out.print("\">");
            out.print(entry.getValue());
            out.println("</meta>");
        }
        if (this.preFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<pre-functions>");
            for (int i = 0; i < this.preFunctions.size(); ++i) {
                function = (FunctionDescriptor)this.preFunctions.get(i);
                function.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</pre-functions>");
        }
        if (this.permissions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<external-permissions>");
            for (int i = 0; i < this.permissions.size(); ++i) {
                PermissionDescriptor permission = (PermissionDescriptor)this.permissions.get(i);
                permission.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</external-permissions>");
        }
        if (this.actions.size() > 0 || this.commonActions.size() > 0) {
            int i;
            XMLUtil.printIndent(out, indent++);
            out.println("<actions>");
            for (i = 0; i < this.commonActions.size(); ++i) {
                out.println("<common-action id=\"" + this.commonActions.get(i) + "\" />");
            }
            for (i = 0; i < this.actions.size(); ++i) {
                ActionDescriptor action = (ActionDescriptor)this.actions.get(i);
                if (action.isCommon()) continue;
                action.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</actions>");
        }
        if (this.postFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<post-functions>");
            for (int i = 0; i < this.postFunctions.size(); ++i) {
                function = (FunctionDescriptor)this.postFunctions.get(i);
                function.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</post-functions>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</step>");
    }

    protected void init(Element step) {
        Element post;
        Element a;
        Element p;
        try {
            this.setId(Integer.parseInt(step.getAttribute("id")));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid step id value " + step.getAttribute("id"));
        }
        this.name = step.getAttribute("name");
        NodeList children = step.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("meta")) continue;
            Element meta = (Element)child;
            String value = XMLUtil.getText(meta);
            this.metaAttributes.put(meta.getAttribute("name"), value);
        }
        Element pre = XMLUtil.getChildElement(step, "pre-functions");
        if (pre != null) {
            List preFunctions = XMLUtil.getChildElements(pre, "function");
            for (int k = 0; k < preFunctions.size(); ++k) {
                Element preFunction = (Element)preFunctions.get(k);
                FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor(preFunction);
                functionDescriptor.setParent(this);
                this.preFunctions.add(functionDescriptor);
            }
        }
        if ((p = XMLUtil.getChildElement(step, "external-permissions")) != null) {
            List permissions = XMLUtil.getChildElements(p, "permission");
            for (int i = 0; i < permissions.size(); ++i) {
                Element permission = (Element)permissions.get(i);
                PermissionDescriptor permissionDescriptor = DescriptorFactory.getFactory().createPermissionDescriptor(permission);
                permissionDescriptor.setParent(this);
                this.permissions.add(permissionDescriptor);
            }
        }
        if ((a = XMLUtil.getChildElement(step, "actions")) != null) {
            this.hasActions = true;
            List actions = XMLUtil.getChildElements(a, "action");
            for (int i = 0; i < actions.size(); ++i) {
                Element action = (Element)actions.get(i);
                ActionDescriptor actionDescriptor = DescriptorFactory.getFactory().createActionDescriptor(action);
                actionDescriptor.setParent(this);
                this.actions.add(actionDescriptor);
            }
            List commonActions = XMLUtil.getChildElements(a, "common-action");
            for (int i = 0; i < commonActions.size(); ++i) {
                Element commonAction = (Element)commonActions.get(i);
                WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)this.getParent();
                try {
                    Integer actionId = new Integer(commonAction.getAttribute("id"));
                    ActionDescriptor commonActionReference = (ActionDescriptor)workflowDescriptor.getCommonActions().get(actionId);
                    if (commonActionReference != null) {
                        this.actions.add(commonActionReference);
                    }
                    this.commonActions.add(actionId);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((post = XMLUtil.getChildElement(step, "post-functions")) != null) {
            List postFunctions = XMLUtil.getChildElements(post, "function");
            for (int k = 0; k < postFunctions.size(); ++k) {
                Element postFunction = (Element)postFunctions.get(k);
                FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor(postFunction);
                functionDescriptor.setParent(this);
                this.postFunctions.add(functionDescriptor);
            }
        }
    }
}

