/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FunctionDescriptor
extends AbstractDescriptor {
    protected Map args = new HashMap();
    protected String name;
    protected String type;

    FunctionDescriptor() {
    }

    FunctionDescriptor(Element function) {
        this.init(function);
    }

    public Map getArgs() {
        return this.args;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        out.println("<function " + (this.hasId() ? "id=\"" + this.getId() + "\" " : "") + (this.name != null && this.name.length() > 0 ? "name=\"" + XMLUtil.encode(this.getName()) + "\" " : "") + "type=\"" + this.type + "\">");
        for (Map.Entry entry : this.args.entrySet()) {
            XMLUtil.printIndent(out, indent);
            out.print("<arg name=\"");
            out.print(entry.getKey());
            out.print("\">");
            if ("beanshell".equals(this.type) || "bsf".equals(this.type)) {
                out.print("<![CDATA[");
                out.print(entry.getValue());
                out.print("]]>");
            } else {
                out.print(XMLUtil.encode(entry.getValue()));
            }
            out.println("</arg>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</function>");
    }

    protected void init(Element function) {
        this.type = function.getAttribute("type");
        try {
            this.setId(Integer.parseInt(function.getAttribute("id")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (function.getAttribute("name") != null) {
            this.name = function.getAttribute("name");
        }
        List args = XMLUtil.getChildElements(function, "arg");
        for (int l = 0; l < args.size(); ++l) {
            Element arg = (Element)args.get(l);
            String value = XMLUtil.getText(arg);
            this.args.put(arg.getAttribute("name"), value);
        }
    }
}

