/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ConditionDescriptor
extends AbstractDescriptor
implements Validatable {
    protected Map args = new HashMap();
    protected String name;
    protected String type;
    protected boolean negate = false;

    ConditionDescriptor() {
    }

    ConditionDescriptor(Element function) {
        this.init(function);
    }

    public Map getArgs() {
        return this.args;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void validate() throws InvalidWorkflowDescriptorException {
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        out.println("<condition " + (this.hasId() ? "id=\"" + this.getId() + "\" " : "") + (this.name != null && this.name.length() > 0 ? "name=\"" + this.getName() + "\" " : "") + (this.negate ? "negate=\"true\" " : "") + "type=\"" + this.type + "\">");
        for (Map.Entry entry : this.args.entrySet()) {
            XMLUtil.printIndent(out, indent);
            out.print("<arg name=\"");
            out.print(entry.getKey());
            out.print("\">");
            if ("beanshell".equals(this.type) || "bsf".equals(this.type)) {
                out.print("<![CDATA[");
                out.print(entry.getValue());
                out.print("]]>");
            } else {
                out.print(XMLUtil.encode(entry.getValue()));
            }
            out.println("</arg>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</condition>");
    }

    protected void init(Element condition) {
        this.type = condition.getAttribute("type");
        try {
            this.setId(Integer.parseInt(condition.getAttribute("id")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String n = condition.getAttribute("negate");
        this.negate = "true".equalsIgnoreCase(n) || "yes".equalsIgnoreCase(n);
        if (condition.getAttribute("name") != null) {
            this.name = condition.getAttribute("name");
        }
        List args = XMLUtil.getChildElements(condition, "arg");
        for (int l = 0; l < args.size(); ++l) {
            Element arg = (Element)args.get(l);
            this.args.put(arg.getAttribute("name"), XMLUtil.getText(arg));
        }
    }
}

