/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.ejb;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.EJBUtils;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.InvalidRoleException;
import com.opensymphony.workflow.QueryNotSupportedException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.ejb.WorkflowHome;
import com.opensymphony.workflow.ejb.WorkflowRemote;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBWorkflow
implements Workflow {
    private static final Log log = LogFactory.getLog(EJBWorkflow.class);
    private WorkflowRemote wf;

    public EJBWorkflow(String location) throws CreateException, RemoteException, WorkflowException {
        WorkflowHome home = null;
        try {
            home = (WorkflowHome)EJBUtils.lookup((String)location, WorkflowHome.class);
        }
        catch (NamingException e) {
            try {
                home = (WorkflowHome)EJBUtils.lookup((String)"java:comp/env/ejb/Workflow", WorkflowHome.class);
            }
            catch (NamingException e1) {
                try {
                    home = (WorkflowHome)EJBUtils.lookup((String)"Workflow", WorkflowHome.class);
                }
                catch (NamingException e2) {
                    throw new WorkflowException("Could not get a handle on the workflow Home EJB", e);
                }
            }
        }
        this.wf = home.create();
    }

    public EJBWorkflow() throws CreateException, RemoteException, WorkflowException {
        this("Workflow");
    }

    @Override
    public int[] getAvailableActions(long id) {
        try {
            return this.wf.getAvailableActions(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting available actions", (Throwable)e);
            return new int[0];
        }
    }

    @Override
    public int[] getAvailableActions(long id, Map inputs) {
        try {
            return this.wf.getAvailableActions(id, inputs);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting available actions", (Throwable)e);
            return new int[0];
        }
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        try {
            this.wf.setConfiguration(configuration);
        }
        catch (RemoteException e) {
            log.fatal((Object)"Error setting configuration", (Throwable)e);
        }
    }

    @Override
    public List getCurrentSteps(long id) {
        try {
            return this.wf.getCurrentSteps(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting current steps", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public int getEntryState(long id) {
        try {
            return this.wf.getEntryState(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting entry state", (Throwable)e);
            return -1;
        }
    }

    @Override
    public List getHistorySteps(long id) {
        try {
            return this.wf.getHistorySteps(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting history steps", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public PropertySet getPropertySet(long id) {
        try {
            return this.wf.getPropertySet(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting PropertySet", (Throwable)e);
            return null;
        }
    }

    @Override
    public List getSecurityPermissions(long id) {
        try {
            return this.wf.getSecurityPermissions(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting security permissions", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List getSecurityPermissions(long id, Map inputs) {
        try {
            return this.wf.getSecurityPermissions(id, inputs);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting security permissions", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public WorkflowDescriptor getWorkflowDescriptor(String workflowName) {
        try {
            return this.wf.getWorkflowDescriptor(workflowName);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting descriptor", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getWorkflowName(long id) {
        try {
            return this.wf.getWorkflowName(id);
        }
        catch (RemoteException e) {
            log.error((Object)"Error getting workflow name", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getWorkflowNames() {
        try {
            return this.wf.getWorkflowNames();
        }
        catch (RemoteException e) {
            log.error((Object)"Error calling getWorkflowNames", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public boolean canInitialize(String workflowName, int initialState) {
        try {
            return this.wf.canInitialize(workflowName, initialState);
        }
        catch (RemoteException e) {
            log.error((Object)"Error checking canInitialize", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean canInitialize(String workflowName, int initialAction, Map inputs) {
        try {
            return this.wf.canInitialize(workflowName, initialAction, inputs);
        }
        catch (RemoteException e) {
            log.error((Object)"Error checking canInitialize", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean canModifyEntryState(long id, int newState) {
        try {
            return this.wf.canModifyEntryState(id, newState);
        }
        catch (RemoteException e) {
            log.error((Object)"Error checking modifying entry state", (Throwable)e);
            return false;
        }
    }

    @Override
    public void changeEntryState(long id, int newState) throws WorkflowException {
        try {
            this.wf.changeEntryState(id, newState);
        }
        catch (RemoteException e) {
            log.error((Object)"Error modifying entry state", (Throwable)e);
            throw new WorkflowException(e);
        }
    }

    @Override
    public void doAction(long id, int actionId, Map inputs) throws InvalidInputException, WorkflowException {
        try {
            this.wf.doAction(id, actionId, inputs);
        }
        catch (RemoteException e) {
            log.error((Object)"Error performing action", (Throwable)e);
            throw new WorkflowException(e);
        }
    }

    @Override
    public void executeTriggerFunction(long id, int triggerId) throws WorkflowException {
        try {
            this.wf.executeTriggerFunction(id, triggerId);
        }
        catch (RemoteException e) {
            log.error((Object)"Error executing trigger", (Throwable)e);
            throw new WorkflowException(e);
        }
    }

    @Override
    public long initialize(String workflowName, int initialState, Map inputs) throws InvalidRoleException, InvalidInputException, WorkflowException {
        try {
            return this.wf.initialize(workflowName, initialState, inputs);
        }
        catch (RemoteException e) {
            log.error((Object)"Error initializing", (Throwable)e);
            throw new WorkflowException(e);
        }
    }

    @Override
    public List query(WorkflowExpressionQuery query) throws WorkflowException {
        throw new QueryNotSupportedException("EJB Store does not support queries");
    }

    @Override
    public List query(WorkflowQuery query) throws WorkflowException {
        throw new QueryNotSupportedException("EJB Store does not support queries");
    }

    @Override
    public boolean removeWorkflowDescriptor(String workflowName) throws FactoryException {
        try {
            return this.wf.removeWorkflowDescriptor(workflowName);
        }
        catch (RemoteException e) {
            log.error((Object)("Error removing workflow " + workflowName), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean saveWorkflowDescriptor(String workflowName, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        try {
            return this.wf.saveWorkflowDescriptor(workflowName, descriptor, replace);
        }
        catch (RemoteException e) {
            log.error((Object)"Error saving workflow", (Throwable)e);
            throw new FactoryException(e);
        }
    }
}

