/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow;

import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ClassLoaderUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeResolver {
    private static final Log log = LogFactory.getLog(TypeResolver.class);
    private static TypeResolver resolver = new TypeResolver();
    protected Map conditions = new HashMap();
    protected Map functions = new HashMap();
    protected Map registers = new HashMap();
    protected Map validators = new HashMap();

    public TypeResolver() {
        this.validators.put("remote-ejb", "com.opensymphony.workflow.util.ejb.remote.RemoteEJBValidator");
        this.validators.put("local-ejb", "com.opensymphony.workflow.util.ejb.local.LocalEJBValidator");
        this.validators.put("jndi", "com.opensymphony.workflow.util.jndi.JNDIValidator");
        this.validators.put("beanshell", "com.opensymphony.workflow.util.beanshell.BeanShellValidator");
        this.validators.put("bsf", "com.opensymphony.workflow.util.bsf.BSFValidator");
        this.conditions.put("remote-ejb", "com.opensymphony.workflow.util.ejb.remote.RemoteEJBCondition");
        this.conditions.put("local-ejb", "com.opensymphony.workflow.util.ejb.local.LocalEJBCondition");
        this.conditions.put("jndi", "com.opensymphony.workflow.util.jndi.JNDICondition");
        this.conditions.put("beanshell", "com.opensymphony.workflow.util.beanshell.BeanShellCondition");
        this.conditions.put("bsf", "com.opensymphony.workflow.util.bsf.BSFCondition");
        this.registers.put("remote-ejb", "com.opensymphony.workflow.util.ejb.remote.RemoteEJBRegister");
        this.registers.put("local-ejb", "com.opensymphony.workflow.util.ejb.local.LocalEJBRegister");
        this.registers.put("jndi", "com.opensymphony.workflow.util.jndi.JNDIRegister");
        this.registers.put("beanshell", "com.opensymphony.workflow.util.beanshell.BeanShellRegister");
        this.registers.put("bsf", "com.opensymphony.workflow.util.bsf.BSFRegister");
        this.functions.put("remote-ejb", "com.opensymphony.workflow.util.ejb.remote.RemoteEJBFunctionProvider");
        this.functions.put("local-ejb", "com.opensymphony.workflow.util.ejb.local.LocalEJBFunctionProvider");
        this.functions.put("jndi", "com.opensymphony.workflow.util.jndi.JNDIFunctionProvider");
        this.functions.put("beanshell", "com.opensymphony.workflow.util.beanshell.BeanShellFunctionProvider");
        this.functions.put("bsf", "com.opensymphony.workflow.util.bsf.BSFFunctionProvider");
    }

    public Condition getCondition(String type, Map args) throws WorkflowException {
        String className = (String)this.conditions.get(type);
        if (className == null) {
            className = (String)args.get("class.name");
        }
        if (className == null) {
            throw new WorkflowException("No type or class.name argument specified to TypeResolver");
        }
        return (Condition)this.loadObject(className);
    }

    public FunctionProvider getFunction(String type, Map args) throws WorkflowException {
        String className = (String)this.functions.get(type);
        if (className == null) {
            className = (String)args.get("class.name");
        }
        if (className == null) {
            throw new WorkflowException("No type or class.name argument specified to TypeResolver");
        }
        return (FunctionProvider)this.loadObject(className);
    }

    public Register getRegister(String type, Map args) throws WorkflowException {
        String className = (String)this.registers.get(type);
        if (className == null) {
            className = (String)args.get("class.name");
        }
        if (className == null) {
            throw new WorkflowException("No type or class.name argument specified to TypeResolver");
        }
        return (Register)this.loadObject(className);
    }

    public static void setResolver(TypeResolver resolver) {
        TypeResolver.resolver = resolver;
    }

    public static TypeResolver getResolver() {
        return resolver;
    }

    public Validator getValidator(String type, Map args) throws WorkflowException {
        String className = (String)this.validators.get(type);
        if (className == null) {
            className = (String)args.get("class.name");
        }
        if (className == null) {
            throw new WorkflowException("No type or class.name argument specified to TypeResolver");
        }
        return (Validator)this.loadObject(className);
    }

    protected Object loadObject(String clazz) {
        try {
            return ClassLoaderUtil.loadClass(clazz.trim(), this.getClass()).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not load class '" + clazz + "'"), (Throwable)e);
            return null;
        }
    }
}

