/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.report.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.plugin.corereports.report.impl.ReportIssue;
import java.util.Collection;

public class TimeTrackingSummaryBean {
    private static final int MAX_GRAPH_WIDTH = 400;
    private final long originalEstimate;
    private final long timeSpent;
    private final long remainingEstimate;
    private final long aggregateOriginalEstimate;
    private final long aggregateTimeSpent;
    private final long aggregateRemainingEstimate;

    TimeTrackingSummaryBean(long totOriginalEst, long totTimeSpent, long totRemainEst) {
        this.originalEstimate = totOriginalEst;
        this.timeSpent = totTimeSpent;
        this.remainingEstimate = totRemainEst;
        this.aggregateOriginalEstimate = totOriginalEst;
        this.aggregateTimeSpent = totTimeSpent;
        this.aggregateRemainingEstimate = totRemainEst;
    }

    TimeTrackingSummaryBean(Collection issues) {
        long totOriginalEst = 0L;
        long totTimeSpent = 0L;
        long totRemainEst = 0L;
        long totAggOriginalEst = 0L;
        long totAggTimeSpent = 0L;
        long totAggRemainEst = 0L;
        for (Object issue1 : issues) {
            ReportIssue reportIssue = (ReportIssue)issue1;
            Issue issue = reportIssue.getIssue();
            totOriginalEst += this.getLongValue(issue.getOriginalEstimate());
            totTimeSpent += this.getLongValue(issue.getTimeSpent());
            totRemainEst += this.getLongValue(issue.getEstimate());
            for (Object o : reportIssue.getSubTasks()) {
                Issue subTask = ((ReportIssue)o).getIssue();
                totOriginalEst += this.getLongValue(subTask.getOriginalEstimate());
                totTimeSpent += this.getLongValue(subTask.getTimeSpent());
                totRemainEst += this.getLongValue(subTask.getEstimate());
            }
            AggregateTimeTrackingBean aggregates = reportIssue.getAggregateBean();
            totAggOriginalEst += this.getLongValue(aggregates.getOriginalEstimate());
            totAggTimeSpent += this.getLongValue(aggregates.getTimeSpent());
            totAggRemainEst += this.getLongValue(aggregates.getRemainingEstimate());
        }
        this.originalEstimate = totOriginalEst;
        this.timeSpent = totTimeSpent;
        this.remainingEstimate = totRemainEst;
        this.aggregateOriginalEstimate = totAggOriginalEst;
        this.aggregateTimeSpent = totAggTimeSpent;
        this.aggregateRemainingEstimate = totAggRemainEst;
    }

    private long getLongValue(Long input) {
        return input == null ? 0L : input;
    }

    public long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public long getTimeSpent() {
        return this.timeSpent;
    }

    public long getRemainingEstimate() {
        return this.remainingEstimate;
    }

    public long getAggregateOriginalEstimate() {
        return this.aggregateOriginalEstimate;
    }

    public long getAggregateRemainingEstimate() {
        return this.aggregateRemainingEstimate;
    }

    public long getAggregateTimeSpent() {
        return this.aggregateTimeSpent;
    }

    public int getCompletionTotalWidth() {
        if (this.timeSpent + this.remainingEstimate > this.originalEstimate) {
            return 400;
        }
        return (int)((float)(this.timeSpent + this.remainingEstimate) / (float)this.originalEstimate * 400.0f);
    }

    public int getEstimationTotalWidth() {
        return 400;
    }

    public int getCompletedWidth() {
        return (int)((float)this.timeSpent / (float)(this.timeSpent + this.remainingEstimate) * (float)this.getCompletionTotalWidth());
    }

    public int getIncompleteWidth() {
        return this.getCompletionTotalWidth() - this.getCompletedWidth();
    }

    public int getEstimateWidth() {
        if (this.originalEstimate > this.timeSpent + this.remainingEstimate) {
            return this.getEstimationTotalWidth();
        }
        return (int)((float)this.originalEstimate / (float)(this.remainingEstimate + this.timeSpent) * (float)this.getEstimationTotalWidth());
    }

    public int getUnderEstimateWidth() {
        if (this.originalEstimate > this.timeSpent + this.remainingEstimate) {
            return 0;
        }
        return this.getEstimationTotalWidth() - this.getEstimateWidth();
    }

    public int getOverEstimateWidth() {
        if (this.originalEstimate > this.timeSpent + this.remainingEstimate) {
            return this.getEstimationTotalWidth() - (this.getCompletedWidth() + this.getIncompleteWidth());
        }
        return 0;
    }
}

