/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.uri.UriBuilder;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class ReportKeyRewriter
extends AbstractHttpFilter {
    private static final Pattern OLD_REPORT_PREFIX = Pattern.compile("^" + Pattern.quote("com.atlassian.jira.plugin.system.reports:"));
    private static final String NEW_REPORT_PREFIX = "com.atlassian.jira.jira-core-reports-plugin:";
    private static final String REPORT_KEY_PARAMETER = "reportKey";

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Optional<String> redirectLocation = Optional.ofNullable(request.getParameter(REPORT_KEY_PARAMETER)).map(OLD_REPORT_PREFIX::matcher).filter(Matcher::find).map(matcher -> this.updateRequestParameterWithNewReportKey(request, (Matcher)matcher));
        if (redirectLocation.isPresent()) {
            response.sendRedirect(redirectLocation.get());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String updateRequestParameterWithNewReportKey(HttpServletRequest request, Matcher oldReportKeyMatcher) {
        return new UriBuilder(request).putQueryParameter(REPORT_KEY_PARAMETER, new String[]{oldReportKeyMatcher.replaceAll(NEW_REPORT_PREFIX)}).toString();
    }
}

